/*
 * Decompiled with CFR 0.152.
 */
package amlib.hw;

import amlib.debug.AlDebug;
import amlib.debug.Debug;
import amlib.debug.a;
import amlib.hw.HWType;
import amlib.hw.ReaderHwException;
import amlib.hw.b;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class HardwareInterface {
    private Object a;
    private UsbManager b;
    private UsbInterface c;
    private UsbDeviceConnection d;
    private UsbEndpoint e;
    private UsbEndpoint f;
    private UsbEndpoint g;
    private boolean h;
    private HWType i;
    private Lock j;
    private AlDebug k;
    private Context l;
    private b m;

    private static native int ClearHalt(int var0, int var1);

    private static native int Reset(int var0);

    public HardwareInterface(HWType hWType, Context object) {
        Object object2;
        this.a();
        this.setAppContext((Context)object);
        object = this;
        if (object.l != null) {
            object.m = new b((HardwareInterface)object, object.l);
            object2 = amlib.debug.a.a();
            ((a)object2).a(object.m);
            object.k = AlDebug.getInstance();
        }
        object2 = hWType;
        object = this;
        switch (object2) {
            case eEMPTY: 
            case eUSB: 
            case eRS232: {
                object.i = object2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Hardware Interface HWType is invalid");
            }
        }
        this.j = new ReentrantLock();
    }

    private static UsbInterface a(UsbDevice usbDevice, boolean n2) {
        UsbInterface usbInterface = null;
        n2 = n2 == 1 ? 4 : 2;
        int n3 = usbDevice.getInterfaceCount();
        Debug.recErrString((byte)0, Debug._LINE_(), n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            usbInterface = usbDevice.getInterface(i2);
            new StringBuilder(" findInterface interface:").append(i2);
            if (usbInterface.getInterfaceClass() != 11 || usbInterface.getInterfaceSubclass() != 0) continue;
            for (int i3 = 0; i3 < usbInterface.getEndpointCount(); ++i3) {
                UsbEndpoint usbEndpoint = usbInterface.getEndpoint(i3);
                new StringBuilder(" endpoint address:").append(Integer.toHexString(usbEndpoint.getAddress()));
                if ((usbEndpoint.getAddress() & 0xF) != n2) continue;
                return usbInterface;
            }
        }
        return usbInterface;
    }

    public boolean Init(UsbManager usbManager, UsbDevice usbDevice) throws ReaderHwException {
        return this.a(usbManager, usbDevice, false);
    }

    private boolean a(UsbManager object, UsbDevice usbDevice, boolean bl) throws ReaderHwException {
        boolean bl2;
        block7: {
            block6: {
                block5: {
                    if (usbDevice == null || object == null) {
                        throw new IllegalArgumentException("UsbDevice or Manager is null");
                    }
                    this.b = object;
                    UsbDevice usbDevice2 = usbDevice;
                    object = this;
                    this.a = usbDevice2;
                    if (!this.b.hasPermission(usbDevice)) {
                        throw new ReaderHwException("USB Device Permission denied");
                    }
                    this.d = this.b.openDevice(usbDevice);
                    this.c = HardwareInterface.a(usbDevice, bl);
                    if (this.c == null) {
                        object = HardwareInterface.a(usbDevice);
                        throw new ReaderHwException("Fail to find correct USB interface\n" + (String)object);
                    }
                    usbDevice2 = this.c;
                    object = this;
                    if (object.d == null) break block5;
                    bl = object.d.claimInterface((UsbInterface)usbDevice2, true);
                    if (!bl) {
                        Debug.recErrString((byte)0, Debug._LINE_(), "false");
                    }
                    if (bl = object.d.claimInterface((UsbInterface)usbDevice2, false)) break block6;
                    new StringBuilder("claimInterface fail:").append(bl);
                    Debug.recErrString((byte)0, Debug._LINE_(), "false");
                    object.d.close();
                    bl2 = false;
                    break block7;
                }
                Debug.recErrString((byte)0, Debug._LINE_(), "null");
                throw new IllegalArgumentException("UsbDeviceConnection is null");
            }
            bl2 = true;
        }
        if (!bl2) {
            throw new ReaderHwException("Fail to claim interface(" + this.c.getId() + "/" + usbDevice.getInterfaceCount() + ")");
        }
        this.a(this.c);
        this.h = true;
        return true;
    }

    private void a(UsbInterface usbInterface) throws ReaderHwException {
        String string = new String();
        for (int i2 = 0; i2 < usbInterface.getEndpointCount(); ++i2) {
            UsbEndpoint usbEndpoint = usbInterface.getEndpoint(i2);
            string = string + "ep-0x" + Integer.toHexString(usbEndpoint.getAddress() & 0xFF) + "\n";
            if (usbEndpoint.getType() == 2) {
                if (usbEndpoint.getDirection() == 0) {
                    this.e = usbEndpoint;
                    new StringBuilder("Got EndpointOut : ").append(this.e.toString());
                    continue;
                }
                this.f = usbEndpoint;
                new StringBuilder("Got EndpointIn : ").append(this.f.toString());
                continue;
            }
            if (usbEndpoint.getType() != 3 || usbEndpoint.getDirection() != 128) continue;
            this.g = usbEndpoint;
            new StringBuilder("Got EndpointInterrupt : ").append(this.g.toString());
        }
        if (this.e == null || this.f == null) {
            Debug.recErrString((byte)0, Debug._LINE_(), " not all endpoints found\n" + string);
            throw new ReaderHwException(" not all endpoints found" + string);
        }
    }

    public boolean initNFC(UsbManager usbManager, UsbDevice usbDevice) throws ReaderHwException {
        UsbDevice usbDevice2 = usbDevice;
        int n2 = usbDevice2.getInterfaceCount();
        if (!(n2 != 1)) {
            return this.a(usbManager, usbDevice, false);
        }
        return this.a(usbManager, usbDevice, true);
    }

    public boolean Close() {
        boolean bl = false;
        if (!this.h) {
            return true;
        }
        if (this.d != null) {
            if (this.c != null) {
                bl = this.d.releaseInterface(this.c);
                if (Build.VERSION.SDK_INT > 21) {
                    if (!bl) {
                        bl = true;
                    }
                    this.c = null;
                }
            }
            this.d.close();
        }
        this.a();
        return bl;
    }

    public int Tx(byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = this.e.getMaxPacketSize();
        byte[] byArray2 = new byte[n4];
        if (!this.IsDevSet()) {
            Debug.recErrString((byte)0, Debug._LINE_(), "false");
            return Debug.retCode((byte)0, Debug._LINE_(), 9);
        }
        if (!this.j.tryLock()) {
            Debug.recErrString((byte)0, Debug._LINE_(), "locked");
            return Debug.retCode((byte)0, Debug._LINE_(), 3);
        }
        do {
            int n5;
            int n6 = n3 + n4 >= n2 ? n2 - n3 : n4;
            for (n5 = 0; n5 < n4; ++n5) {
                byArray2[n5] = 0;
            }
            System.arraycopy(byArray, n3, byArray2, 0, n6);
            for (n5 = 0; n5 < n6; ++n5) {
                this.k.b("pBuffToSend[" + n5 + "]=" + Integer.toHexString(byArray2[n5] & 0xFF), new Object[0]);
            }
            n5 = this.d.bulkTransfer(this.e, byArray2, n6, 5000);
            Debug.recErrString((byte)0, Debug._LINE_(), n5);
            if (n5 < 0) {
                this.j.unlock();
                new StringBuilder("bulk tx error ").append(n5);
                Debug.recErrString((byte)0, Debug._LINE_(), this.e.getAddress(), n6);
                Debug.recErrString((byte)0, Debug._LINE_(), byArray2, n6);
                this.a(this.d.getFileDescriptor(), this.e);
                return Debug.retCode((byte)0, Debug._LINE_(), 1);
            }
            new StringBuilder("Bulk write ").append(Integer.toString(n5)).append(" bytes successfully");
        } while ((n3 += n4) < n2);
        this.j.unlock();
        return 0;
    }

    public int Rx(byte[] byArray, int[] nArray) {
        if (!this.IsDevSet()) {
            new String("Device is not initialed");
            return Debug.retCode((byte)0, Debug._LINE_(), 9);
        }
        if (!this.j.tryLock()) {
            return Debug.retCode((byte)0, Debug._LINE_(), 3);
        }
        int n2 = this.d.bulkTransfer(this.f, byArray, nArray[0], 5000);
        Debug.recErrString((byte)0, Debug._LINE_(), n2);
        if (n2 < 0) {
            new StringBuilder("bulk read error(").append(n2).append(") : ").append(this.f.toString());
            Debug.recErrString((byte)0, Debug._LINE_(), this.e.getAddress(), nArray[0]);
            if (nArray[0] > 0) {
                Debug.recErrString((byte)0, Debug._LINE_(), byArray, nArray[0]);
            }
            this.a(this.d.getFileDescriptor(), this.f);
            this.j.unlock();
            return Debug.retCode((byte)0, Debug._LINE_(), 1);
        }
        new StringBuilder("Bulk Read ").append(Integer.toString(n2)).append(" bytes successfully");
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray = new Object[]{};
            String string = "pBuffToRead[" + i2 + "]=" + Integer.toHexString(byArray[i2] & 0xFF);
            HardwareInterface hardwareInterface = this;
            hardwareInterface.k.b(string, objectArray);
        }
        nArray[0] = n2;
        this.j.unlock();
        return 0;
    }

    private boolean a(int n2, int n3, int n4, int n5, byte[] byArray, int[] nArray, int n6) {
        if (this.d == null) {
            return false;
        }
        try {
            n2 = this.d.controlTransfer(n2, n3, n4, n5, byArray, nArray[0], 1000);
            if (n2 < 0) {
                new StringBuilder("controlTransfer fail ").append(n2);
                Debug.recErrString((byte)0, Debug._LINE_(), n2);
                HardwareInterface.ClearHalt(this.d.getFileDescriptor(), 128);
                HardwareInterface.ClearHalt(this.d.getFileDescriptor(), 0);
                return false;
            }
            if (n2 < nArray[0]) {
                new StringBuilder("controlTransfer short packetage ").append(n2);
                Debug.recErrString((byte)0, Debug._LINE_(), n2, nArray[0]);
                nArray[0] = n2;
            } else {
                nArray[0] = n2;
            }
        }
        catch (Exception exception) {
            new StringBuilder("get description Exception : ").append(exception.getMessage());
        }
        return true;
    }

    private void a(int n2, UsbEndpoint usbEndpoint) {
        int n3 = usbEndpoint.getAddress();
        new StringBuilder("getAddress=").append(Integer.toHexString(n3));
        HardwareInterface.ClearHalt(n2, n3);
    }

    public boolean getSerialNumber(byte[] byArray, byte[] byArray2) {
        int n2;
        byte[] byArray3 = new byte[2];
        HardwareInterface hardwareInterface = this;
        byte[] byArray4 = new byte[18];
        byte[] byArray5 = byArray4;
        int[] nArray = new int[]{18};
        if (!hardwareInterface.usbCtrl(byArray5, 128, 6, 256, 0, nArray)) {
            return false;
        }
        byte by = byArray4[16];
        if (by == 0) {
            Debug.recErrString((byte)0, Debug._LINE_(), byArray4[16]);
            byArray2[0] = 0;
            return true;
        }
        new StringBuilder("Serial Number index is ").append(by);
        byte[] byArray6 = new byte[24];
        byArray5 = byArray3;
        hardwareInterface = this;
        byArray4 = new byte[255];
        int n3 = hardwareInterface.a(byArray4, (byte)0, 0);
        Debug.recErrString((byte)0, Debug._LINE_(), Boolean.toString(n3 != 0) + "/" + Byte.toString(byArray4[0]));
        if (n3 == 1 || byArray4[0] != 4) {
            byArray5[0] = byArray4[2];
            byArray5[1] = byArray4[3];
            Debug.recErrString((byte)0, Debug._LINE_(), byArray5[0], byArray5[1]);
        }
        if ((n2 = n3) == 0) {
            return false;
        }
        n2 = byArray3[0] << 4 | byArray3[1];
        boolean bl = this.a(byArray6, by, n2);
        n2 = bl ? 1 : 0;
        if (!bl) {
            return false;
        }
        new StringBuilder("SerialNum[0] = ").append(byArray6[0]);
        byArray2[0] = (byte)(byArray6[0] & 0xFD);
        System.arraycopy(byArray6, 2, byArray, 0, byArray2[0]);
        return true;
    }

    private boolean a(byte[] byArray, byte by, int n2) {
        int n3 = 0x300 | by & 0xFF;
        int[] nArray = new int[]{64};
        if (!this.usbCtrl(byArray, 128, 6, n3, n2 & 0xFFFF, nArray)) {
            return false;
        }
        Debug.recErrString((byte)0, Debug._LINE_(), byArray[0], byArray[1]);
        return byArray[1] == 3;
    }

    private static String a(UsbDevice usbDevice) {
        int n2 = usbDevice.getInterfaceCount();
        String string = new String();
        if (n2 == 0) {
            string = "Usb getInterfaceCount() returns 0";
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            UsbInterface usbInterface = usbDevice.getInterface(i2);
            string = string + "-----interface:" + i2 + "------";
            for (int i3 = 0; i3 < usbInterface.getEndpointCount(); ++i3) {
                UsbEndpoint usbEndpoint = usbInterface.getEndpoint(i3);
                string = string + "ep-0x" + Integer.toHexString(usbEndpoint.getAddress() & 0xFF) + "\n";
            }
        }
        return string;
    }

    public boolean usbCtrl(byte[] byArray, int n2, int n3, int n4, int n5, int[] nArray) {
        byte[] byArray2 = new byte[512];
        if (byArray == null) {
            throw new IllegalArgumentException("getDesc parameter is invalid");
        }
        boolean bl = this.a(n2, n3, n4, n5, byArray2, nArray, 1000);
        n2 = bl ? 1 : 0;
        if (!bl) {
            return false;
        }
        try {
            System.arraycopy(byArray2, 0, byArray, 0, nArray[0]);
        }
        catch (Exception exception) {
            new StringBuilder("copy buffer Exception : ").append(exception.getMessage());
        }
        return true;
    }

    public boolean usbResetDevice() throws ReaderHwException {
        HardwareInterface.Reset(this.d.getFileDescriptor());
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            interruptedException.printStackTrace();
        }
        return this.Init(this.b, (UsbDevice)this.a);
    }

    public Object getmDevObj() {
        return this.a;
    }

    public void setAppContext(Context context) {
        this.l = context;
    }

    public boolean IsDevSet() {
        return this.a != null && this.h;
    }

    private void a() {
        this.a = null;
        this.d = null;
        this.e = null;
        this.f = null;
        this.h = false;
    }

    public HWType getHWType() {
        return this.i;
    }

    public int getMaxTxPkLength() {
        return this.e.getMaxPacketSize();
    }

    public int getMaxRxPkLength() {
        return this.f.getMaxPacketSize();
    }

    static {
        System.loadLibrary("AlUSB");
    }
}

