/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk.fingerprint;

import android.util.Log;
import com.paydevice.smartpos.sdk.DeviceNative;
import com.paydevice.smartpos.sdk.SmartPosException;

public class FingerPrintManager {
    private static final String TAG = "FingerPrintManager";
    private static boolean initFlag = false;
    public static final int FINGERPRINT_ERR_NO_INIT = 1;
    public static final int FINGERPRINT_ERR_INIT = 2;
    public static final int FINGERPRINT_ERR_DEINIT = 3;
    public static final int FINGERPRINT_ERR_ALREADY_INIT = 4;
    public static final int FINGERPRINT_ERR_NO_FINGER = 7;
    public static final int FINGERPRINT_ERR_IMAGE_UNCLEAR = 8;
    public static final int FINGERPRINT_ERR_IO = 99;
    public static final int FINGERPRINT_FINGER_PRESENT = 183;

    public void init() throws SmartPosException {
        if (!initFlag) {
            int ret = DeviceNative.nativeFingerPrintInit();
            if (ret < 0) {
                throw new SmartPosException(2);
            }
        } else {
            throw new SmartPosException(4);
        }
        initFlag = true;
    }

    public void deinit() {
        DeviceNative.nativeFingerPrintDeinit();
        initFlag = false;
    }

    public int getBitmapWidth() {
        return DeviceNative.nativeFingerPrintGetImageWidth();
    }

    public int getBitmapHeight() {
        return DeviceNative.nativeFingerPrintGetImageHeight();
    }

    public byte[] getBitmapBytes() throws SmartPosException {
        if (!initFlag) {
            throw new SmartPosException(1);
        }
        int err = 0;
        int w = DeviceNative.nativeFingerPrintGetImageWidth();
        int h2 = DeviceNative.nativeFingerPrintGetImageHeight();
        byte[] bmpBytes = new byte[w * h2 + 1078];
        err = DeviceNative.nativeFingerPrintGetImage(bmpBytes);
        switch (err) {
            case 1: {
                throw new SmartPosException(7);
            }
            case 2: {
                throw new SmartPosException(8);
            }
            case 9: {
                throw new SmartPosException(99);
            }
        }
        return bmpBytes;
    }

    public byte[] getMinutiae() throws SmartPosException {
        if (!initFlag) {
            throw new SmartPosException(1);
        }
        Log.d((String)TAG, (String)"function getMinutiae does not implemented");
        return null;
    }

    public int compare(byte[] probe, byte[] candidate) throws SmartPosException {
        if (!initFlag) {
            throw new SmartPosException(1);
        }
        Log.d((String)TAG, (String)"function compare does not implemented");
        return 0;
    }

    static {
        try {
            System.loadLibrary("paydevice-smartpos");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

