
package com.paydevice.smartpos.demo;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.widget.CompoundButton;
import android.widget.Switch;
import com.paydevice.smartpos.sdk.led.LedManager;

public class LedActivity extends AppCompatActivity
    implements CompoundButton.OnCheckedChangeListener {

    private static final String TAG = "LedActivity";

    private LedManager mLedManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_led);
        setTitle(R.string.led);
        Switch redSwitch = findViewById(R.id.switch_red);
        Switch greenSwitch = findViewById(R.id.switch_green);
        Switch blueSwitch = findViewById(R.id.switch_blue);
		redSwitch.setOnCheckedChangeListener(this);
		greenSwitch.setOnCheckedChangeListener(this);
		blueSwitch.setOnCheckedChangeListener(this);

		mLedManager = new LedManager();
    }

    @Override
    public void onPause() {
        super.onPause();

        mLedManager.setRedLed(false);
        mLedManager.setGreenLed(false);
        mLedManager.setBlueLed(false);
    }

	@Override
	public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        int err = 0;
		switch (buttonView.getId()) {
            case R.id.switch_red:
                mLedManager.setRedLed(isChecked);
                break;

            case R.id.switch_green:
                mLedManager.setGreenLed(isChecked);
                break;

            case R.id.switch_blue:
                mLedManager.setBlueLed(isChecked);
                break;

			default:
				break;
		}
	}
}
