package com.paydevice.smartpos.demo;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;

import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.paydevice.smartpos.sdk.samcard.SamCardManager;

import java.util.ArrayList;
import java.util.List;

public class SamCardActivity extends AppCompatActivity {

    private static final String TAG = "SamCardActivity";

	private MyToast mToast;
    //UI object
    private TextView mTextResponse;
    private EditText mTextCommand;
    private EditText mTextTimeout;
    private Button mBtnOpen;
    private Button mBtnClose;
    private Button mBtnSend;


    private SamCardManager mSamCardManager;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setTitle(R.string.samcard);
        setContentView(R.layout.activity_samcard);

        initUI();
        mSamCardManager = new SamCardManager();
    }

    @Override
	protected void onResume() {
		super.onResume();

        //init reader
        if (mSamCardManager.init() < 0) {
            mBtnOpen.setEnabled(false);
            mToast.showToast(getString(R.string.str_reader_nofound));
        } else {
            mBtnOpen.setEnabled(true);
        }
        mBtnClose.setEnabled(false);
        mBtnSend.setEnabled(false);
	}

    @Override
    public void onPause() {
        //deinit reader
        mSamCardManager.cardClose(SamCardManager.CARD_SLOT_1);
		mSamCardManager.deinit();

		mToast.cancel();
        super.onPause();
    }

    public void onOpenBtnClick(View view) {
        mTextResponse.setText("");
        //detect card, optional
        int err = mSamCardManager.cardDetect(SamCardManager.CARD_SLOT_1);
        if (err < 0) {
            Log.d(TAG, "card detect err:"+err);
            mToast.showToast(String.format(getString(R.string.str_open_failed), err));
            return;
        }
        byte[] atr = new byte[64];
        //NOTE: default parameters should be work with most card. Also you can set special parameters, but need you refer card specification.
        //int config = SamCardManager.CARD_VOLTAGE_3V0 | SamCardManager.CARD_PPS_SUPPORT | SamCardManager.CARD_BPS_9600 | SamCardManager.CARD_NOCHECK_SPEC; 
        int config = SamCardManager.CARD_PARAMS_DEFAULT;
        //open card
        err = mSamCardManager.cardOpen(SamCardManager.CARD_SLOT_1, config, atr);
        if (err < 0) {
            mToast.showToast("open slot " + SamCardManager.CARD_SLOT_1 + " err code:" + err);
        } else {
            mBtnOpen.setEnabled(false);
            mBtnSend.setEnabled(true);
            mBtnClose.setEnabled(true);
            mToast.showToast("open slot " + SamCardManager.CARD_SLOT_1 + " type " + (err == SamCardManager.CARD_TYPE_T1 ? "T1" : "T0"));
            int atrLen = (atr[0]<<8)|atr[1];
            Log.d(TAG, "ATR:"+Utils.printBytes(atr, 2, atrLen));
        }
    }

    public void onSendBtnClick(View view) {
        String tmp = mTextCommand.getText().toString().replace(" ","");
        int timeoutMs = Integer.parseInt(mTextTimeout.getText().toString());

        if (!Utils.isHexString(tmp) && (tmp.length()&1) != 0) {
            mToast.showToast("APDU invalid");
            return;
        }
        //send APDU command
        byte[] command = Utils.stringToBytes(tmp);
        byte[] response = new byte[SamCardManager.CARD_RESP_MAX_LEN];
        int err = mSamCardManager.cardExchange(SamCardManager.CARD_SLOT_1, command, command.length, response, response.length, timeoutMs);
        if (err < 0) {
            mToast.showToast("slot "+SamCardManager.CARD_SLOT_1+": exchange error code:"+String.valueOf(err));
            mTextResponse.setText("");
        } else {
            mTextResponse.setText("bytes("+ String.valueOf(err) + ")"+Utils.printBytes(response, 0, err));
        }
    }

    public void onCloseBtnClick(View view) {
        mTextResponse.setText("");
        mSamCardManager.cardClose(SamCardManager.CARD_SLOT_1);
        mBtnOpen.setEnabled(true);
        mBtnSend.setEnabled(false);
        mBtnClose.setEnabled(false);
    }

	private void initUI() {
		mToast = new MyToast(this);

        mTextResponse = (TextView) findViewById(R.id.text_response);
        mTextCommand = (EditText) findViewById(R.id.editText_command);
        mTextTimeout = (EditText) findViewById(R.id.editText_timeout);
        //NOTE: we test 'GET CHALLENGE' command but not all card support
        mTextCommand.setText("0084000004");
        //mTextCommand.setText("00A404000E315041592E5359532E444446303108");

		mBtnOpen = (Button) findViewById(R.id.button_open);
		mBtnClose = (Button) findViewById(R.id.button_close);
		mBtnSend = (Button) findViewById(R.id.button_send);
	}

}
