
package com.paydevice.smartpos.demo.smartcard;

import android.annotation.SuppressLint;
import android.support.v7.app.AppCompatActivity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

import com.paydevice.smartpos.demo.R;
import com.paydevice.smartpos.demo.MyToast;
import com.paydevice.smartpos.demo.Utils;
import com.paydevice.smartpos.sdk.SmartPosException;
import com.paydevice.smartpos.sdk.smartcard.SmartCardManager;

public class AT88SC102Activity extends AppCompatActivity {

    private static final String TAG = "AT88SC102Activity";

    private static final String KEY_RESULT = "result";
    private static final String KEY_ERR_CODE = "code";

    private static final int MSG_OPEN_RESULT = 1;
    private static final int MSG_CLOSE_RESULT = 2;
    private boolean mOpenFlag = false;
    
    private SmartCardManager mSmartCardManager;

	private MyToast mToast;
    private TextView mText;
    private TextView mEditBitsRead;
    private TextView mEditBitsIncAddr;
    private TextView mEditBitsGotoAddr;
    private TextView mEditByteIncAddr;
    private TextView mEditByteRead;
    private TextView mEditByteWrite;
    private TextView mEditByteCompare;

	private ProgressDialog mWaitProgress; 

    private Button mOpenBtn;
    private Button mCloseBtn;
    private Button mFusPinHighBtn;
    private Button mFusPinLowBtn;
    private Button mRstPinHighBtn;
    private Button mRstPinLowBtn;
    private Button mResetBtnBtn;
    private Button mBitsReadBtn;
    private Button mBitsIncAddrBtn;
    private Button mBitsGotoAddrBtn;
    private Button mBitsGetCurrAddrBtn;
    private Button mSingleBitWriteBtn;
    private Button mSingleBitEraseBtn;
    private Button mByteIncAddrBtn;
    private Button mByteReadBtn;
    private Button mByteWriteBtn;
    private Button mByteCompareBtn;

    private OpenTask mOpenTask;
    private CloseTask mCloseTask;

    private Builder mSlotDialog;
    private int mSlotSelected = 0;
    private int mSlotCount = 1;

    @SuppressLint("HandlerLeak")
    public Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            Boolean result = msg.getData().getBoolean(KEY_RESULT);
			if (mWaitProgress != null && mWaitProgress.isShowing())
				mWaitProgress.dismiss();
            switch (msg.what) {
                case MSG_CLOSE_RESULT:
                    if (result) {
                        mToast.showToast(R.string.smartcard_close_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        mCloseBtn.setEnabled(false);
                        mText.setText("errCode: " + errCode + " " + SmartCardManager.errCode2String(errCode));
                        mToast.showToast(R.string.smartcard_close_failed);
                    }
                    mOpenBtn.setEnabled(true);
					mFusPinHighBtn.setEnabled(false);
					mFusPinLowBtn.setEnabled(false);
					mRstPinHighBtn.setEnabled(false);
					mRstPinLowBtn.setEnabled(false);
					mResetBtnBtn.setEnabled(false);
					mBitsReadBtn.setEnabled(false);
					mBitsIncAddrBtn.setEnabled(false);
					mBitsGotoAddrBtn.setEnabled(false);
					mBitsGetCurrAddrBtn.setEnabled(false);
					mSingleBitWriteBtn.setEnabled(false);
					mSingleBitEraseBtn.setEnabled(false);
					mByteIncAddrBtn.setEnabled(false);
					mByteReadBtn.setEnabled(false);
					mByteWriteBtn.setEnabled(false);
					mByteCompareBtn.setEnabled(false);

                    mOpenFlag = false;
                    break;


                case MSG_OPEN_RESULT:
                    if (result) {
                        mCloseBtn.setEnabled(true);
						mFusPinHighBtn.setEnabled(true);
						mFusPinLowBtn.setEnabled(true);
						mRstPinHighBtn.setEnabled(true);
						mRstPinLowBtn.setEnabled(true);
						mResetBtnBtn.setEnabled(true);
						mBitsReadBtn.setEnabled(true);
						mBitsIncAddrBtn.setEnabled(true);
						mBitsGotoAddrBtn.setEnabled(true);
						mBitsGetCurrAddrBtn.setEnabled(true);
						mSingleBitWriteBtn.setEnabled(true);
						mSingleBitEraseBtn.setEnabled(true);
						mByteIncAddrBtn.setEnabled(true);
						mByteReadBtn.setEnabled(true);
						mByteWriteBtn.setEnabled(true);
						mByteCompareBtn.setEnabled(true);

                        mOpenFlag = true;
                        mToast.showToast(R.string.smartcard_open_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        if (errCode == SmartCardManager.SCR_ERR_NO_INIT) {
                            init();
                            if (mSlotCount > 1) {
                                mSlotDialog.show();
                            } else {
                                open();
                            }
                        } else {
                            mOpenBtn.setEnabled(true);
							mText.setText("errCode: " + errCode + " " + SmartCardManager.errCode2String(errCode));
                            mToast.showToast(R.string.smartcard_open_failed);
                        }
                    }
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.at88sc102);
        setTitle(R.string.smartcard_mode_at88sc102);

        mText = findViewById(R.id.text_result);
        mEditBitsRead = findViewById(R.id.edit_bits_read);
        mEditBitsIncAddr = findViewById(R.id.edit_bits_inc_addr);
        mEditBitsGotoAddr = findViewById(R.id.edit_bits_goto_addr);
        mEditByteIncAddr = findViewById(R.id.edit_byte_inc_addr);
        mEditByteRead = findViewById(R.id.edit_byte_read);
        mEditByteWrite = findViewById(R.id.edit_byte_write);
        mEditByteCompare = findViewById(R.id.edit_byte_compare);

        mOpenBtn = findViewById(R.id.btn_open);
        mCloseBtn = findViewById(R.id.btn_close);
        mFusPinHighBtn = findViewById(R.id.btn_fus_high);
        mFusPinLowBtn = findViewById(R.id.btn_fus_low);
        mRstPinHighBtn = findViewById(R.id.btn_rst_high);
        mRstPinLowBtn = findViewById(R.id.btn_rst_low);
        mResetBtnBtn = findViewById(R.id.btn_reset);
        mBitsReadBtn = findViewById(R.id.btn_bits_read);
        mBitsIncAddrBtn = findViewById(R.id.btn_bits_inc_addr);
        mBitsGotoAddrBtn = findViewById(R.id.btn_bits_goto_addr);
        mBitsGetCurrAddrBtn = findViewById(R.id.btn_bits_get_addr);
        mSingleBitWriteBtn = findViewById(R.id.btn_single_bit_write);
        mSingleBitEraseBtn = findViewById(R.id.btn_single_bit_erase);
        mByteIncAddrBtn = findViewById(R.id.btn_byte_inc_addr);
        mByteReadBtn = findViewById(R.id.btn_byte_read);
        mByteWriteBtn = findViewById(R.id.btn_byte_write);
        mByteCompareBtn = findViewById(R.id.btn_compare);

        mCloseBtn.setEnabled(false);
		mFusPinHighBtn.setEnabled(false);
		mFusPinLowBtn.setEnabled(false);
		mRstPinHighBtn.setEnabled(false);
		mRstPinLowBtn.setEnabled(false);
		mResetBtnBtn.setEnabled(false);
		mBitsReadBtn.setEnabled(false);
		mBitsIncAddrBtn.setEnabled(false);
		mBitsGotoAddrBtn.setEnabled(false);
		mBitsGetCurrAddrBtn.setEnabled(false);
		mSingleBitWriteBtn.setEnabled(false);
		mSingleBitEraseBtn.setEnabled(false);
		mByteIncAddrBtn.setEnabled(false);
		mByteReadBtn.setEnabled(false);
		mByteWriteBtn.setEnabled(false);
		mByteCompareBtn.setEnabled(false);

		mWaitProgress =  new ProgressDialog(this);  
		mWaitProgress.setCancelable(false);
		mWaitProgress.setProgressStyle(ProgressDialog.STYLE_SPINNER);

        setReaderSlotView();

		mSmartCardManager = new SmartCardManager();
		mToast = new MyToast(this);
		//we just init reader to get slot count, unnecessary for single slot.
        init();
        mSmartCardManager.deinit();
    }

    @Override
    protected void onPause() {
        super.onPause();
		mToast.cancel();
    }

    @Override
    public void onDestroy() {
        //NOTE: power off card and deinit
        Log.d(TAG, "onDestroy()");
        if (mOpenFlag) {
            close();
        } else {
            mSmartCardManager.deinit();
            Log.d(TAG, "Deinit");
            if (mCloseTask != null && mCloseTask.getStatus() != AsyncTask.Status.FINISHED) {
                mCloseTask.cancel(true);
            }
        }
        if (mOpenTask != null && mOpenTask.getStatus() != AsyncTask.Status.FINISHED) {
            mOpenTask.cancel(true);
        }

        super.onDestroy();
    }

	public void onOpenBtnClick(View v) {
		if (mSlotCount > 1) {
			mSlotDialog.show();
		} else {
			open();
		}
	}

	public void onCloseBtnClick(View v) {
		mText.setText("");
		mWaitProgress.setMessage("Closing...");
		mWaitProgress.show();
		close();
	}

	public void OnSetFusPinHighClick(View v) {
		int code = mSmartCardManager.AT88SC102CmdSetFusPinHigh();
		if (code == 0)
			mText.setText("SetFusPinHigh");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnSetFusPinLowClick(View v) {
		int code = mSmartCardManager.AT88SC102CmdSetFusPinLow();
		if (code == 0)
			mText.setText("SetFusPinLow");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnSetRstPinHighClick(View v) {
		int code = mSmartCardManager.AT88SC102CmdSetRstPinHigh();
		if (code == 0)
			mText.setText("SetRstPinHigh");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnSetRstPinLowClick(View v) {
		int code = mSmartCardManager.AT88SC102CmdSetRstPinLow();
		if (code == 0)
			mText.setText("SetRstPinLow");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnResetClick(View v) {
		int code = mSmartCardManager.AT88SC102CmdOpReset();
		if (code == 0)
			mText.setText("Reset");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnBitsReadClick(View v) {
		String tmp = mEditBitsRead.getText().toString();
		int readLen = Integer.parseInt(tmp, 16);
		byte[] readData = new byte[256];

		int code = mSmartCardManager.AT88SC102CmdOpBitsRead(readLen, readData);
		if (code == 0)
			mText.setText("BitsRead:"+Utils.bytesToHexString(readData));
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnBitsIncAddrClick(View v) {
		String tmp = mEditBitsIncAddr.getText().toString();
		int addr = Integer.parseInt(tmp, 16);

		int code = mSmartCardManager.AT88SC102CmdOpBitsIncAddr(addr);
		if (code == 0)
			mText.setText("BitsIncAddr success");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnBitsGotoAddrClick(View v) {
		String tmp = mEditBitsGotoAddr.getText().toString();
		int addr = Integer.parseInt(tmp, 16);

		int code = mSmartCardManager.AT88SC102CmdOpBitsGotoAddr(addr);
		if (code == 0)
			mText.setText("BitsGotoAddr success");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnBitsGetAddrClick(View v) {
		int[] addr = new int[1];
		int code = mSmartCardManager.AT88SC102CmdOpBitGetAddr(addr);
		if (code == 0)
			mText.setText("BitsGetAddr:"+addr[0]);
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnSingleBitWriteClick(View v) {
		int code = mSmartCardManager.AT88SC102CmdOpSingleBitWrite();
		if (code == 0)
			mText.setText("SingleBitWrite success");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnSingleBitEraseClick(View v) {
		int code = mSmartCardManager.AT88SC102CmdOpSingleBitErase();
		if (code == 0)
			mText.setText("SingleBitErase success");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnByteIncAddrClick(View v) {
		String tmp = mEditByteIncAddr.getText().toString();
		int addr = Integer.parseInt(tmp, 16);

		int code = mSmartCardManager.AT88SC102CmdOpBytesIncAddr(addr);
		if (code == 0)
			mText.setText("ByteIncAddr success");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnByteReadClick(View v) {
		String tmp = mEditByteRead.getText().toString();
		int readLen = Integer.parseInt(tmp, 16);
		byte[] readData = new byte[256];

		int code = mSmartCardManager.AT88SC102CmdOpBytesRead(readLen, readData);
		if (code == 0)
			mText.setText("ByteRead:"+Utils.bytesToHexString(readData));
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnByteWriteClick(View v) {
		String tmp = mEditByteWrite.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.AT88SC102CmdOpBytesWrite(data.length, data);
		if (code == 0)
			mText.setText("ByteWrite success");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

	public void OnByteCompareClick(View v) {
		String tmp = mEditByteCompare.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.AT88SC102CmdOpBytesComp(data.length, data);
		if (code == 0)
			mText.setText("ByteCompare success");
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

    private void init() {
        int errCode;
        String errMsg = null;
        try {
			//init AT88SC102 mode
			mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_AT88SC102);
            Log.d(TAG, "got slot count:" + mSlotCount);
        } catch (SmartPosException e) {
            mOpenBtn.setEnabled(false);
            errCode = e.getErrorCode();
            switch (errCode) {
                case SmartCardManager.SCR_ERR_INIT:
                    errMsg = "Reader init error!";
                    break;
            }
            Log.d(TAG, "init errCode:" + errCode + " " + errMsg);
            mText.setText("errCode: " + errCode + "  " + errMsg);
            mToast.showToast(R.string.smartcard_init_err);
        }
    }

    private void open() {
        Log.d(TAG, "open slot:" + mSlotSelected);
        mOpenBtn.setEnabled(false);
        mOpenTask = new OpenTask();
        mOpenTask.execute(this);
    }

    private void close() {
        mCloseBtn.setEnabled(false);
        mCloseTask = new CloseTask();
        mCloseTask.execute();
    }

    private void setReaderSlotView() {
        final String[] arraySlot = new String[]{"slot:0", "Slot:1"};
        mSlotDialog = new AlertDialog.Builder(this);
        DialogInterface.OnClickListener Select = new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                mSlotSelected = (byte) which;
            }
        };

        DialogInterface.OnClickListener OkClick = new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                open();
            }
        };

        mSlotDialog.setPositiveButton("OK", OkClick);
        mSlotDialog.setTitle("Select Slot Number");
        mSlotDialog.setSingleChoiceItems(arraySlot, 0, Select);
    }


    /**
     * @brief helper class for init smartcard reader
     */
    private class OpenTask extends AsyncTask<Context, Void, Boolean> {
        private int errCode;

		@Override 
		protected void onPreExecute() {
			mWaitProgress.setMessage("Opening...");
			mWaitProgress.show();
		}

        @Override
        protected Boolean doInBackground(Context... params) {
            if (isCancelled()) {
                return false;
            }
            try {
				//init AT88SC102 mode
                mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_AT88SC102);
                mSmartCardManager.selectSlot(mSlotSelected);
                Log.d(TAG, "Select slot:" + mSlotSelected);
                mSmartCardManager.powerOn();
                Log.d(TAG, "Power On");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            try {
                Message msg = new Message();
                msg.what = MSG_OPEN_RESULT;
                Bundle bundle = new Bundle();
                bundle.putBoolean(KEY_RESULT, result);
                if (result) {
                } else {
                    bundle.putInt(KEY_ERR_CODE, errCode);
                }
                msg.setData(bundle);
                mHandler.sendMessage(msg);
            } catch (Exception e) {
                Log.d(TAG, "open task err!");
            }
        }
    }

    /**
     * @brief helper class for deinit smartcard reader
     */
    private class CloseTask extends AsyncTask<Void, Void, Boolean> {
        int errCode;

        @Override
        protected Boolean doInBackground(Void... params) {
            if (isCancelled()) {
                return false;
            }
            try {
                mSmartCardManager.powerOff();
                Log.d(TAG, "Power Off");
                mSmartCardManager.deinit();
                Log.d(TAG, "Deinit");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            Message msg = new Message();
            msg.what = MSG_CLOSE_RESULT;
            Bundle bundle = new Bundle();
            bundle.putBoolean(KEY_RESULT, result);
            if (!result) {
                bundle.putInt(KEY_ERR_CODE, errCode);
            }
            msg.setData(bundle);
            mHandler.sendMessage(msg);
        }
    }
}
