
package com.paydevice.smartpos.demo.smartcard;

import android.annotation.SuppressLint;
import android.support.v7.app.AppCompatActivity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

import com.paydevice.smartpos.demo.R;
import com.paydevice.smartpos.demo.MyToast;
import com.paydevice.smartpos.demo.Utils;
import com.paydevice.smartpos.sdk.SmartPosException;
import com.paydevice.smartpos.sdk.smartcard.SmartCardManager;

public class SLE4428Activity extends AppCompatActivity {

    private static final String TAG = "SLE4428Activity";

    private static final String KEY_RESULT = "result";
    private static final String KEY_ERR_CODE = "code";

    private static final int MSG_OPEN_RESULT = 1;
    private static final int MSG_CLOSE_RESULT = 2;
    private boolean mOpenFlag = false;
    
    private SmartCardManager mSmartCardManager;

	private MyToast mToast;
    private TextView mText;
    private TextView mEditWriteAddr;
    private TextView mEditWriteData;
    private TextView mEditReadAddr;
    private TextView mEditReadLength;
    private TextView mEditVerifyData;
    private TextView mEditPsc1;
    private TextView mEditPsc2;

	private ProgressDialog mWaitProgress; 

    private Button mOpenBtn;
    private Button mCloseBtn;
    private Button mWriteWithPb;
    private Button mWriteWithoutPb;
    private Button mWritePbWithData;
    private Button mRead9Bits;
    private Button mRead8Bits;
    private Button mWriteErrCounter;
    private Button mVerify1stPsc;
    private Button mVerify2ndPsc;
    private Button mVerifyPsc;

    private OpenTask mOpenTask;
    private CloseTask mCloseTask;

    private Builder mSlotDialog;
    private int mSlotSelected = 0;
    private int mSlotCount = 1;

    @SuppressLint("HandlerLeak")
    public Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            Boolean result = msg.getData().getBoolean(KEY_RESULT);
			if (mWaitProgress != null && mWaitProgress.isShowing())
				mWaitProgress.dismiss();
            switch (msg.what) {
                case MSG_CLOSE_RESULT:
                    if (result) {
                        mToast.showToast(R.string.smartcard_close_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        mCloseBtn.setEnabled(false);
						mText.setText("errCode: " + Integer.toHexString(errCode) + " " + SmartCardManager.errCode2String(errCode));
                        mToast.showToast(R.string.smartcard_close_failed);
                    }
                    mOpenBtn.setEnabled(true);
					mWriteWithPb.setEnabled(false);
					mWriteWithoutPb.setEnabled(false);
					mWritePbWithData.setEnabled(false);
					mRead9Bits.setEnabled(false);
					mRead8Bits.setEnabled(false);
					mWriteErrCounter.setEnabled(false);
					mVerify1stPsc.setEnabled(false);
					mVerify2ndPsc.setEnabled(false);
					mVerifyPsc.setEnabled(false);

                    mOpenFlag = false;
                    break;


                case MSG_OPEN_RESULT:
                    if (result) {
                        mCloseBtn.setEnabled(true);
						mWriteWithPb.setEnabled(true);
						mWriteWithoutPb.setEnabled(true);
						mWritePbWithData.setEnabled(true);
						mRead9Bits.setEnabled(true);
						mRead8Bits.setEnabled(true);
						mWriteErrCounter.setEnabled(true);
						mVerify1stPsc.setEnabled(true);
						mVerify2ndPsc.setEnabled(true);
						mVerifyPsc.setEnabled(true);

                        mOpenFlag = true;
                        mToast.showToast(R.string.smartcard_open_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        if (errCode == SmartCardManager.SCR_ERR_NO_INIT) {
                            init();
                            if (mSlotCount > 1) {
                                mSlotDialog.show();
                            } else {
                                open();
                            }
                        } else {
                            mOpenBtn.setEnabled(true);
							mText.setText("errCode: " + Integer.toHexString(errCode) + " " + SmartCardManager.errCode2String(errCode));
                            mToast.showToast(R.string.smartcard_open_failed);
                        }
                    }
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.sle4428);
        setTitle(R.string.smartcard_mode_sle4428);

        mText = findViewById(R.id.text_result);
        mEditWriteAddr = findViewById(R.id.edit_write_addr);
        mEditWriteData = findViewById(R.id.edit_write_data);
        mEditReadAddr = findViewById(R.id.edit_read_addr);
        mEditReadLength = findViewById(R.id.edit_read_length);
        mEditVerifyData = findViewById(R.id.edit_verify_data);
        mEditPsc1 = findViewById(R.id.edit_psc1);
        mEditPsc2 = findViewById(R.id.edit_psc2);

        mOpenBtn = findViewById(R.id.btn_open);
        mCloseBtn = findViewById(R.id.btn_close);
        mWriteWithPb = findViewById(R.id.btn_write_erase_with_pb);
        mWriteWithoutPb = findViewById(R.id.btn_write_erase_without_pb);
        mWritePbWithData = findViewById(R.id.btn_write_pb_with_data);
        mWriteErrCounter = findViewById(R.id.btn_write_errcounter);
        mRead9Bits = findViewById(R.id.btn_read_9bits);
        mRead8Bits = findViewById(R.id.btn_read_8bits);
        mVerify1stPsc = findViewById(R.id.btn_verify_1st_psc);
        mVerify2ndPsc = findViewById(R.id.btn_verify_2nd_psc);
        mVerifyPsc = findViewById(R.id.btn_verify_psc);

		mCloseBtn.setEnabled(false);
		mWriteWithPb.setEnabled(false);
		mWriteWithoutPb.setEnabled(false);
		mWritePbWithData.setEnabled(false);
		mRead9Bits.setEnabled(false);
		mRead8Bits.setEnabled(false);
		mWriteErrCounter.setEnabled(false);
		mVerify1stPsc.setEnabled(false);
		mVerify2ndPsc.setEnabled(false);
		mVerifyPsc.setEnabled(false);

		mWaitProgress = new ProgressDialog(this);  
		mWaitProgress.setCancelable(false);
		mWaitProgress.setProgressStyle(ProgressDialog.STYLE_SPINNER);

        setReaderSlotView();

		mSmartCardManager = new SmartCardManager();
		mToast = new MyToast(this);
		//we just init reader to get slot count, unnecessary for single slot.
        init();
        mSmartCardManager.deinit();
    }

    @Override
    protected void onPause() {
        super.onPause();
		mToast.cancel();
    }

    @Override
    public void onDestroy() {
        //NOTE: power off card and deinit
        Log.d(TAG, "onDestroy()");
        if (mOpenFlag) {
            close();
        } else {
            mSmartCardManager.deinit();
            Log.d(TAG, "Deinit");
            if (mCloseTask != null && mCloseTask.getStatus() != AsyncTask.Status.FINISHED) {
                mCloseTask.cancel(true);
            }
        }
        if (mOpenTask != null && mOpenTask.getStatus() != AsyncTask.Status.FINISHED) {
            mOpenTask.cancel(true);
        }

        super.onDestroy();
    }

	public void onOpenBtnClick(View v) {
		if (mSlotCount > 1) {
			mSlotDialog.show();
		} else {
			open();
		}
	}

	public void onCloseBtnClick(View v) {
		mText.setText("");
		mWaitProgress.setMessage("Closing...");
		mWaitProgress.show();
		close();
	}

	public void OnWriteWithPbClick(View v) {
		String tmp = mEditWriteAddr.getText().toString();
		int addr = Integer.parseInt(tmp,16);
		tmp = mEditWriteData.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE4428CmdWriteEraseWithPB(addr, data[0]);
		if (code == 0) {
			mText.setText("Write and erase with PB success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnWriteWithoutPbClick(View v) {
		String tmp = mEditWriteAddr.getText().toString();
		int addr = Integer.parseInt(tmp,16);
		tmp = mEditWriteData.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE4428CmdWriteEraseWithoutPB(addr, data[0]);
		if (code == 0) {
			mText.setText("Write and erase without PB success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnWritePbWithDataClick(View v) {
		String tmp = mEditWriteAddr.getText().toString();
		int addr = Integer.parseInt(tmp,16);
		tmp = mEditWriteData.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE4428CmdWritePBWithDataComparison(addr, data[0]);
		if (code == 0) {
			mText.setText("Write PB with data comparsion success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnRead9BitsClick(View v) {
		int [] readLen = new int[1];
		String tmp = mEditReadAddr.getText().toString();
		int addr = Integer.parseInt(tmp,16);
		tmp = mEditReadLength.getText().toString();
		int len = Integer.parseInt(tmp,16);
		if (len > 128)
			len = 128;
		byte[] data = new byte[len];
		byte[] pbData = new byte[len&0xff];

		int code = mSmartCardManager.SLE4428CmdRead9Bits(addr, len, data, pbData, readLen);
		if (code == 0) {
			mText.setText("ReadData:"+Utils.bytesToHexString(data)+ "\nReadPBData:"+Utils.bytesToHexString(pbData));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnRead8BitsClick(View v) {
		int [] readLen = new int[1];
		String tmp = mEditReadAddr.getText().toString();
		int addr = Integer.parseInt(tmp,16);
		tmp = mEditReadLength.getText().toString();
		int len = Integer.parseInt(tmp,16);
		if (len > 128)
			len = 128;
		byte[] data = new byte[len];

		int code = mSmartCardManager.SLE4428CmdRead8Bits(addr, len, data, readLen);
		if (code == 0) {
			mText.setText("ReadData:"+Utils.bytesToHexString(data));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnWriteErrCounter(View v) {
		String tmp = mEditVerifyData.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE4428CmdWriteErrorCounter(data[0]);
		if (code == 0) {
			mText.setText("Write error counter success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnVerify1stPscClick(View v) {
		String tmp = mEditVerifyData.getText().toString();
		Log.d(TAG,"psc:"+tmp);
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE4428CmdVerify1stPSC(data[0]);
		if (code == 0) {
			mText.setText("Verify 1st PSC success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnVerify2ndPscClick(View v) {
		String tmp = mEditVerifyData.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE4428CmdVerify2ndPSC(data[0]);
		if (code == 0) {
			mText.setText("Verify 2nd PSC success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnVerifyPscClick(View v) {
		int [] errReason = new int[1];
		String tmp = mEditPsc1.getText().toString();
		byte[] psc1 = Utils.stringToBytes(tmp);
		tmp = mEditPsc2.getText().toString();
		byte[] psc2 = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE4428CmdVerifyPSCAndEraseErrorCounter(psc1[0], psc2[0], errReason);
		if (code == 0) {
			mText.setText("Verify PSC and erase error counter success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

    private void init() {
        int errCode;
        String errMsg = null;
        try {
			//init SLE4428 mode
			mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_SLE4428);
            Log.d(TAG, "got slot count:" + mSlotCount);
        } catch (SmartPosException e) {
            mOpenBtn.setEnabled(false);
            errCode = e.getErrorCode();
            switch (errCode) {
                case SmartCardManager.SCR_ERR_INIT:
                    errMsg = "Reader init error!";
                    break;
            }
            mText.setText("errCode: " + Integer.toHexString(errCode) + "  " + errMsg);
            mToast.showToast(R.string.smartcard_init_err);
        }
    }

    private void open() {
        Log.d(TAG, "open slot:" + mSlotSelected);
        mOpenBtn.setEnabled(false);
        mOpenTask = new OpenTask();
        mOpenTask.execute(this);
    }

    private void close() {
        mCloseBtn.setEnabled(false);
        mCloseTask = new CloseTask();
        mCloseTask.execute();
    }

    private void setReaderSlotView() {
        final String[] arraySlot = new String[]{"slot:0", "Slot:1"};
        mSlotDialog = new AlertDialog.Builder(this);
        DialogInterface.OnClickListener Select = new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                mSlotSelected = (byte) which;
            }
        };

        DialogInterface.OnClickListener OkClick = new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                open();
            }
        };

        mSlotDialog.setPositiveButton("OK", OkClick);
        mSlotDialog.setTitle("Select Slot Number");
        mSlotDialog.setSingleChoiceItems(arraySlot, 0, Select);
    }


    /**
     * @brief helper class for init smartcard reader
     */
    private class OpenTask extends AsyncTask<Context, Void, Boolean> {
        private int errCode;

		@Override 
		protected void onPreExecute() {
			mWaitProgress.setMessage("Opening...");
			mWaitProgress.show();
		}

        @Override
        protected Boolean doInBackground(Context... params) {
            if (isCancelled()) {
                return false;
            }
            try {
				//init SLE4428 mode
                mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_SLE4428);
                mSmartCardManager.selectSlot(mSlotSelected);
                Log.d(TAG, "Select slot:" + mSlotSelected);
                mSmartCardManager.powerOn();
                Log.d(TAG, "Power On");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            try {
                Message msg = new Message();
                msg.what = MSG_OPEN_RESULT;
                Bundle bundle = new Bundle();
                bundle.putBoolean(KEY_RESULT, result);
                if (result) {
                } else {
                    bundle.putInt(KEY_ERR_CODE, errCode);
                }
                msg.setData(bundle);
                mHandler.sendMessage(msg);
            } catch (Exception e) {
                Log.d(TAG, "open task err!");
            }
        }
    }

    /**
     * @brief helper class for deinit smartcard reader
     */
    private class CloseTask extends AsyncTask<Void, Void, Boolean> {
        int errCode;

        @Override
        protected Boolean doInBackground(Void... params) {
            if (isCancelled()) {
                return false;
            }
            try {
                mSmartCardManager.powerOff();
                Log.d(TAG, "Power Off");
                mSmartCardManager.deinit();
                Log.d(TAG, "Deinit");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            Message msg = new Message();
            msg.what = MSG_CLOSE_RESULT;
            Bundle bundle = new Bundle();
            bundle.putBoolean(KEY_RESULT, result);
            if (!result) {
                bundle.putInt(KEY_ERR_CODE, errCode);
            }
            msg.setData(bundle);
            mHandler.sendMessage(msg);
        }
    }
}
