
package com.paydevice.smartpos.demo.smartcard;

import android.annotation.SuppressLint;
import android.support.v7.app.AppCompatActivity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

import com.paydevice.smartpos.demo.R;
import com.paydevice.smartpos.demo.MyToast;
import com.paydevice.smartpos.demo.Utils;
import com.paydevice.smartpos.sdk.SmartPosException;
import com.paydevice.smartpos.sdk.smartcard.SmartCardManager;

public class SLE4442Activity extends AppCompatActivity {

    private static final String TAG = "SLE4442Activity";

    private static final byte FIXED_LEN_TO_READ = 4;

    private static final String KEY_RESULT = "result";
    private static final String KEY_ERR_CODE = "code";

    private static final int MSG_OPEN_RESULT = 1;
    private static final int MSG_CLOSE_RESULT = 2;
    private boolean mOpenFlag = false;
    
    private SmartCardManager mSmartCardManager;

	private MyToast mToast;
    private TextView mText;
    private TextView mEditPin1;
    private TextView mEditPin2;
    private TextView mEditPin3;
    private TextView mEditMainAddr;
    private TextView mEditMainLength;
    private TextView mEditMainData;
    private TextView mEditProtectAddr;
    private TextView mEditProtectData;
    private TextView mEditSecurityAddr;
    private TextView mEditSecurityData;

	private ProgressDialog mWaitProgress; 

    private Button mOpenBtn;
    private Button mCloseBtn;
    private Button mVerifyBtn;
    private Button mReadMainBtn;
    private Button mUpdateMainBtn;
    private Button mReadProtectBtn;
    private Button mWriteProtectBtn;
    private Button mReadSecurityBtn;
    private Button mUpdateSecurityBtn;
    private Button mCompareBtn;

    private OpenTask mOpenTask;
    private CloseTask mCloseTask;

    private Builder mSlotDialog;
    private int mSlotSelected = 0;
    private int mSlotCount = 1;

    @SuppressLint("HandlerLeak")
    public Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            Boolean result = msg.getData().getBoolean(KEY_RESULT);
			if (mWaitProgress != null && mWaitProgress.isShowing())
				mWaitProgress.dismiss();
            switch (msg.what) {
                case MSG_CLOSE_RESULT:
                    if (result) {
                        mToast.showToast(R.string.smartcard_close_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        mCloseBtn.setEnabled(false);
                        mText.setText("errCode: " + Integer.toHexString(errCode) + " " + SmartCardManager.errCode2String(errCode));
                        mToast.showToast(R.string.smartcard_close_failed);
                    }
                    mOpenBtn.setEnabled(true);
					mCloseBtn.setEnabled(false);
					mVerifyBtn.setEnabled(false);
					mReadMainBtn.setEnabled(false);
					mUpdateMainBtn.setEnabled(false);
					mReadProtectBtn.setEnabled(false);
					mWriteProtectBtn.setEnabled(false);
					mReadSecurityBtn.setEnabled(false);
					mUpdateSecurityBtn.setEnabled(false);
					mCompareBtn.setEnabled(false);
                    mOpenFlag = false;
                    break;


                case MSG_OPEN_RESULT:
                    if (result) {
                        mCloseBtn.setEnabled(true);
						mVerifyBtn.setEnabled(true);
						mReadMainBtn.setEnabled(true);
						mUpdateMainBtn.setEnabled(true);
						mReadProtectBtn.setEnabled(true);
						mWriteProtectBtn.setEnabled(true);
						mReadSecurityBtn.setEnabled(true);
						mUpdateSecurityBtn.setEnabled(true);
						mCompareBtn.setEnabled(true);
                        mOpenFlag = true;
                        mToast.showToast(R.string.smartcard_open_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        if (errCode == SmartCardManager.SCR_ERR_NO_INIT) {
                            init();
                            if (mSlotCount > 1) {
                                mSlotDialog.show();
                            } else {
                                open();
                            }
                        } else {
                            mOpenBtn.setEnabled(true);
							mText.setText("errCode: " + Integer.toHexString(errCode) + " " + SmartCardManager.errCode2String(errCode));
                            mToast.showToast(R.string.smartcard_open_failed);
                        }
                    }
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.sle4442);
        setTitle(R.string.smartcard_mode_sle4442);

        mText = findViewById(R.id.text_result);
        mEditPin1 = findViewById(R.id.edit_pin1);
        mEditPin2 = findViewById(R.id.edit_pin2);
        mEditPin3 = findViewById(R.id.edit_pin3);
        mEditMainAddr = findViewById(R.id.edit_main_addr);
        mEditMainLength = findViewById(R.id.edit_main_length);
        mEditMainData = findViewById(R.id.edit_main_data);
        mEditProtectAddr = findViewById(R.id.edit_prot_addr);
        mEditProtectData = findViewById(R.id.edit_prot_data);
        mEditSecurityAddr = findViewById(R.id.edit_secu_addr);
        mEditSecurityData = findViewById(R.id.edit_secu_data);

        mOpenBtn = findViewById(R.id.btn_open);
        mCloseBtn = findViewById(R.id.btn_close);
        mVerifyBtn = findViewById(R.id.btn_verify);
        mReadMainBtn = findViewById(R.id.btn_read_main);
        mUpdateMainBtn = findViewById(R.id.btn_update_main);
        mReadProtectBtn = findViewById(R.id.btn_read_prot);
        mWriteProtectBtn = findViewById(R.id.btn_write_prot);
        mReadSecurityBtn = findViewById(R.id.btn_read_secu);
        mUpdateSecurityBtn = findViewById(R.id.btn_update_secu);
        mCompareBtn = findViewById(R.id.btn_comp_data);

        mCloseBtn.setEnabled(false);
        mVerifyBtn.setEnabled(false);
        mReadMainBtn.setEnabled(false);
        mUpdateMainBtn.setEnabled(false);
        mReadProtectBtn.setEnabled(false);
        mWriteProtectBtn.setEnabled(false);
        mReadSecurityBtn.setEnabled(false);
        mUpdateSecurityBtn.setEnabled(false);
        mCompareBtn.setEnabled(false);

		mWaitProgress =  new ProgressDialog(this);  
		mWaitProgress.setCancelable(false);
		mWaitProgress.setProgressStyle(ProgressDialog.STYLE_SPINNER);

        setReaderSlotView();

		mSmartCardManager = new SmartCardManager();
		mToast = new MyToast(this);
		//we just init reader to get slot count, unnecessary for single slot.
        init();
        mSmartCardManager.deinit();
    }

    @Override
    protected void onPause() {
        super.onPause();
		mToast.cancel();
    }

    @Override
    public void onDestroy() {
        //NOTE: power off card and deinit
        Log.d(TAG, "onDestroy()");
        if (mOpenFlag) {
            close();
        } else {
            mSmartCardManager.deinit();
            Log.d(TAG, "Deinit");
            if (mCloseTask != null && mCloseTask.getStatus() != AsyncTask.Status.FINISHED) {
                mCloseTask.cancel(true);
            }
        }
        if (mOpenTask != null && mOpenTask.getStatus() != AsyncTask.Status.FINISHED) {
            mOpenTask.cancel(true);
        }

        super.onDestroy();
    }

	public void onOpenBtnClick(View v) {
		if (mSlotCount > 1) {
			mSlotDialog.show();
		} else {
			open();
		}
	}

	public void onCloseBtnClick(View v) {
		mText.setText("");
		mWaitProgress.setMessage("Closing...");
		mWaitProgress.show();
		close();
	}

	public void OnVerifyBtnClick(View v) {
		byte []pin = new byte[3];
		String tmp = mEditPin1.getText().toString();
		pin[0] = Utils.stringToBytes(tmp)[0];
		tmp = mEditPin2.getText().toString();
		pin[1] = Utils.stringToBytes(tmp)[0];
		tmp = mEditPin3.getText().toString();
		pin[2] = Utils.stringToBytes(tmp)[0];

		int code = mSmartCardManager.SLE4442CmdVerify(3, pin);
		if (code == 0) {
			mText.setText("pin matched:"+Utils.bytesToHexString(pin));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnReadMainBtnClick(View v){
		int [] readLen = new int[1];
		String tmp = mEditMainAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditMainLength.getText().toString();
		int len = Integer.parseInt(tmp,16);
		byte[] data = new byte[len];

		int code = mSmartCardManager.SLE4442CmdReadMainMemory(addr[0], (byte)len, data, readLen);
		if (code == 0) {
			mText.setText("ReadMainMem:"+Utils.bytesToHexString(data));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnUpdateMainBtnClick(View v){
		String tmp = mEditMainAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditMainData.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE4442CmdUpdateMainMemory(addr[0], data[0]);
		if (code == 0) {
			mText.setText("UpdateMainMem:"+Utils.bytesToHexString(data));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnReadSecurityBtnClick(View v){
		//fixed length 4bytes;
		byte[] data = new byte[FIXED_LEN_TO_READ];
		int [] readLen = new int[1];

		int code = mSmartCardManager.SLE4442CmdReadSecurityMemory(FIXED_LEN_TO_READ, data, readLen);
		if (code == 0) {
			mText.setText("ReadSecurityMem:"+Utils.bytesToHexString(data));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnUpdateSecurityBtnClick(View v){
		String tmp = mEditSecurityAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditSecurityData.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE4442CmdUpdateSecurityMemory(addr[0], data[0]);
		if (code == 0) {
			mText.setText("UpdateSecurityMem success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnCompareDataBtnClick(View v){
		String tmp = mEditSecurityAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditSecurityData.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE4442CmdCompareVerificationData(addr[0], data[0]);
		if (code == 0) {
			mText.setText("compare verification data success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnReadProtectBtnClick(View v){
		//fixed length 4bytes;
		byte[] data = new byte[FIXED_LEN_TO_READ];
		int [] readLen = new int[1];

		int code = mSmartCardManager.SLE4442CmdReadProtectionMemory(FIXED_LEN_TO_READ, data, readLen);
		if (code == 0) {
			mText.setText("ReadProtectionMen:"+Utils.bytesToHexString(data));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnWriteProtectBtnClick(View v){
		String tmp = mEditProtectAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditProtectData.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE4442CmdWriteProtectionMemory(addr[0], data[0]);
		if (code == 0) {
			mText.setText("WriteProtectionMen success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

    private void init() {
        int errCode;
        String errMsg = null;
        try {
			//init SLE4442 mode
			mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_SLE4442);
            Log.d(TAG, "got slot count:" + mSlotCount);
        } catch (SmartPosException e) {
            mOpenBtn.setEnabled(false);
            errCode = e.getErrorCode();
            switch (errCode) {
                case SmartCardManager.SCR_ERR_INIT:
                    errMsg = "Reader init error!";
                    break;
            }
            mText.setText("errCode: " + Integer.toHexString(errCode) + "  " + errMsg);
            mToast.showToast(R.string.smartcard_init_err);
        }
    }

    private void open() {
        Log.d(TAG, "open slot:" + mSlotSelected);
        mOpenBtn.setEnabled(false);
        mOpenTask = new OpenTask();
        mOpenTask.execute(this);
    }

    private void close() {
        mCloseBtn.setEnabled(false);
        mCloseTask = new CloseTask();
        mCloseTask.execute();
    }

    private void setReaderSlotView() {
        final String[] arraySlot = new String[]{"slot:0", "Slot:1"};
        mSlotDialog = new AlertDialog.Builder(this);
        DialogInterface.OnClickListener Select = new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                mSlotSelected = (byte) which;
            }
        };

        DialogInterface.OnClickListener OkClick = new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                open();
            }
        };

        mSlotDialog.setPositiveButton("OK", OkClick);
        mSlotDialog.setTitle("Select Slot Number");
        mSlotDialog.setSingleChoiceItems(arraySlot, 0, Select);
    }


    /**
     * @brief helper class for init smartcard reader
     */
    private class OpenTask extends AsyncTask<Context, Void, Boolean> {
        private int errCode;

		@Override 
		protected void onPreExecute() {
			mWaitProgress.setMessage("Opening...");
			mWaitProgress.show();
		}

        @Override
        protected Boolean doInBackground(Context... params) {
            if (isCancelled()) {
                return false;
            }
            try {
				//init SLE4442 mode
                mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_SLE4442);
                mSmartCardManager.selectSlot(mSlotSelected);
                Log.d(TAG, "Select slot:" + mSlotSelected);
                mSmartCardManager.powerOn();
                Log.d(TAG, "Power On");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            try {
                Message msg = new Message();
                msg.what = MSG_OPEN_RESULT;
                Bundle bundle = new Bundle();
                bundle.putBoolean(KEY_RESULT, result);
                if (result) {
                } else {
                    bundle.putInt(KEY_ERR_CODE, errCode);
                }
                msg.setData(bundle);
                mHandler.sendMessage(msg);
            } catch (Exception e) {
                Log.d(TAG, "open task err!");
            }
        }
    }

    /**
     * @brief helper class for deinit smartcard reader
     */
    private class CloseTask extends AsyncTask<Void, Void, Boolean> {
        int errCode;

        @Override
        protected Boolean doInBackground(Void... params) {
            if (isCancelled()) {
                return false;
            }
            try {
                mSmartCardManager.powerOff();
                Log.d(TAG, "Power Off");
                mSmartCardManager.deinit();
                Log.d(TAG, "Deinit");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            Message msg = new Message();
            msg.what = MSG_CLOSE_RESULT;
            Bundle bundle = new Bundle();
            bundle.putBoolean(KEY_RESULT, result);
            if (!result) {
                bundle.putInt(KEY_ERR_CODE, errCode);
            }
            msg.setData(bundle);
            mHandler.sendMessage(msg);
        }
    }
}
