/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk.printer;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Log;
import com.paydevice.smartpos.sdk.DeviceNative;
import com.paydevice.smartpos.sdk.SmartPosException;
import com.paydevice.smartpos.sdk.gpio.Gpio;
import com.paydevice.smartpos.sdk.printer.Printer;
import com.paydevice.smartpos.sdk.printer.PrinterCommand;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Arrays;

public class PrinterManager {
    private static final String TAG = "PrinterManager";
    private static final int PRINTER_BUFFER_LEN = 1024;
    public static final int PRINTER_ERR_OPEN = 1;
    public static final int PRINTER_ERR_CLOSE = 2;
    public static final int PRINTER_ERR_READ = 3;
    public static final int PRINTER_ERR_WRITE = 4;
    public static final int PRINTER_ERR_PARAM = 5;
    public static final int PRINTER_ERR_NO_PAPER = 6;
    public static final int PRINTER_ERR_UPDATE = 7;
    public static final int PRINTER_TYPE_USB = 1;
    public static final int PRINTER_TYPE_SERIAL = 2;
    public static final int PRINTER_TYPE_NETWORK = 3;
    public static final int PRINTER_TYPE_BLUETOOTH = 4;
    public static final int PRINTER_MODEL_UNKNOWN = 0;
    public static final int PRINTER_MODEL_PRN2103 = 1;
    public static final int FULL_CUT = 0;
    public static final int HALF_CUT = 1;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int FONT_DEFAULT = 0;
    public static final int FONT_SMALL = 1;
    public static final int FONT_INVERSE = 2;
    public static final int FONT_UPSIDE_DOWN = 4;
    public static final int FONT_EMPHASIZED = 8;
    public static final int FONT_DOUBLE_HEIGHT = 16;
    public static final int FONT_DOUBLE_WIDTH = 32;
    public static final int FONT_ROTATE = 64;
    public static final int FONT_UNDERLINE = 128;
    public static final int UNDERLINE_ZERO = 0;
    public static final int UNDERLINE_HIGH_1 = 1;
    public static final int UNDERLINE_HIGH_2 = 2;
    public static final int CODEBAR_STRING_MODE_NONE = 0;
    public static final int CODEBAR_STRING_MODE_ABOVE = 1;
    public static final int CODEBAR_STRING_MODE_BELOW = 2;
    public static final int CODEBAR_STRING_MODE_BOTH = 3;
    public static final int CODEBAR_STRING_FONT_A = 0;
    public static final int CODEBAR_STRING_FONT_B = 1;
    public static final int UPC_A = 65;
    public static final int UPC_E = 66;
    public static final int EAN13 = 67;
    public static final int EAN8 = 68;
    public static final int CODE39 = 69;
    public static final int I25 = 70;
    public static final int CODABAR = 71;
    public static final int CODE93 = 72;
    public static final int CODE128 = 73;
    public static final int CODE11 = 74;
    public static final int MSI = 75;
    public static final int QR_ECC_LEVEL_L = 1;
    public static final int QR_ECC_LEVEL_M = 2;
    public static final int QR_ECC_LEVEL_Q = 3;
    public static final int QR_ECC_LEVEL_H = 4;
    public static final int CHAR_SET_USA = 0;
    public static final int CHAR_SET_FRANCE = 1;
    public static final int CHAR_SET_GERMANY = 2;
    public static final int CHAR_SET_ENGLAND = 3;
    public static final int CHAR_SET_DENMARK_I = 4;
    public static final int CHAR_SET_SWEDEN = 5;
    public static final int CHAR_SET_ITALY = 6;
    public static final int CHAR_SET_SPAIN_I = 7;
    public static final int CHAR_SET_JAPAN = 8;
    public static final int CHAR_SET_NORWAY = 9;
    public static final int CHAR_SET_DENMARK_II = 10;
    public static final int CHAR_SET_SPAIN_II = 11;
    public static final int CHAR_SET_LATIN_AMERICA = 12;
    public static final int CHAR_SET_KOREA = 13;
    public static final int CHAR_SET_CROATIA = 14;
    public static final int CHAR_SET_CHINA = 15;
    public static final int CODE_PAGE_CP437 = 0;
    public static final int CODE_PAGE_KATAKANA = 1;
    public static final int CODE_PAGE_CP850 = 2;
    public static final int CODE_PAGE_CP860 = 3;
    public static final int CODE_PAGE_CP863 = 4;
    public static final int CODE_PAGE_CP865 = 5;
    public static final int CODE_PAGE_CP1251 = 6;
    public static final int CODE_PAGE_CP866 = 7;
    public static final int CODE_PAGE_MIK = 8;
    public static final int CODE_PAGE_CP755 = 9;
    public static final int CODE_PAGE_IRAN = 10;
    public static final int CODE_PAGE_CP862 = 15;
    public static final int CODE_PAGE_CP1252 = 16;
    public static final int CODE_PAGE_CP1253 = 17;
    public static final int CODE_PAGE_CP852 = 18;
    public static final int CODE_PAGE_CP858 = 19;
    public static final int CODE_PAGE_IRAN2 = 20;
    public static final int CODE_PAGE_LATVIAN = 21;
    public static final int CODE_PAGE_CP864 = 22;
    public static final int CODE_PAGE_ISO_8859_1 = 23;
    public static final int CODE_PAGE_CP737 = 24;
    public static final int CODE_PAGE_CP1257 = 25;
    public static final int CODE_PAGE_THAI = 26;
    public static final int CODE_PAGE_CP720 = 27;
    public static final int CODE_PAGE_CP855 = 28;
    public static final int CODE_PAGE_CP857 = 29;
    public static final int CODE_PAGE_CP1250 = 30;
    public static final int CODE_PAGE_CP775 = 31;
    public static final int CODE_PAGE_CP1254 = 32;
    public static final int CODE_PAGE_CP1255 = 33;
    public static final int CODE_PAGE_CP1256 = 34;
    public static final int CODE_PAGE_CP1258 = 35;
    public static final int CODE_PAGE_ISO_8859_2 = 36;
    public static final int CODE_PAGE_ISO_8859_3 = 37;
    public static final int CODE_PAGE_ISO_8859_4 = 38;
    public static final int CODE_PAGE_ISO_8859_5 = 39;
    public static final int CODE_PAGE_ISO_8859_6 = 40;
    public static final int CODE_PAGE_ISO_8859_7 = 41;
    public static final int CODE_PAGE_ISO_8859_8 = 42;
    public static final int CODE_PAGE_ISO_8859_9 = 43;
    public static final int CODE_PAGE_ISO_8859_15 = 44;
    public static final int CODE_PAGE_THAI2 = 45;
    public static final int CODE_PAGE_CP856 = 46;
    public static final int CODE_PAGE_CP874 = 47;
    public static final int CODE_PAGE_SHIFT_JIS = 96;
    public static final int CODE_PAGE_EUC_KR = 97;
    public static final int CODE_PAGE_BIG5 = 98;
    public static final int CODE_PAGE_GB18030 = 99;
    public static final int BITMAP_ZOOM_NONE = 0;
    public static final int BITMAP_ZOOM_WIDTH = 1;
    public static final int BITMAP_ZOOM_HEIGHT = 2;
    public static final int BITMAP_ZOOM_BOTH = 3;
    public static final int TYPE_PAPER_WIDTH_58MM = 0;
    public static final int TYPE_PAPER_WIDTH_80MM = 1;
    private final int[] bmp_byte_width = new int[]{48, 72};
    private final int[] dots_per_line = new int[]{384, 576};
    private final Printer mPrinter;
    private final int mPaperWidthType;
    private String mEncoding = "UTF-8";
    private int mTotalCount;
    private int mBmpCount;
    private int mPowerOffDelay;
    private long mFirstStamp;
    private long mLastStamp;

    public PrinterManager(Printer printer, int paperWidthType) {
        this.mPrinter = printer;
        this.mPaperWidthType = paperWidthType;
    }

    public int getPrinterType() {
        if (this.mPrinter == null) {
            return 0;
        }
        return this.mPrinter.getType();
    }

    public void connect() throws SmartPosException {
        if (this.mPrinter == null) {
            throw new SmartPosException(1);
        }
        if (this.mPrinter.getType() == 2) {
            this.mPowerOffDelay = 0;
            this.mTotalCount = 0;
            this.mBmpCount = 0;
            this.turnOn(true);
        }
        this.mPrinter.open();
        this.sendCmd(PrinterCommand.cmdESCat());
    }

    public void disconnect() throws SmartPosException {
        this.disconnect(false);
    }

    public void disconnect(boolean turnOff) throws SmartPosException {
        if (this.mPrinter == null) {
            throw new SmartPosException(2);
        }
        this.mPrinter.close();
        if (this.mPrinter.getType() == 2 && turnOff) {
            this.mLastStamp = SystemClock.uptimeMillis();
            int printTime = (int)((float)this.mTotalCount * 2.4038f);
            int sendTime = (int)(this.mLastStamp - this.mFirstStamp);
            this.mPowerOffDelay = printTime > sendTime && sendTime > 1000 ? (this.mPowerOffDelay += printTime - sendTime / 2) : (this.mPowerOffDelay += printTime);
            this.mPowerOffDelay += this.mBmpCount * 500 + 500;
            try {
                Thread.sleep(this.mPowerOffDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mPowerOffDelay = 0;
            this.mTotalCount = 0;
            this.mBmpCount = 0;
            this.turnOn(false);
        }
    }

    public void checkPaper() throws SmartPosException {
        int ret = 0;
        byte[] status = new byte[1];
        int paper_adc = SystemProperties.getInt((String)"hw.printer_adc", (int)-1);
        if (this.mPrinter.getType() == 2 && paper_adc > -1) {
            int adc = DeviceNative.nativeAdcGetValue(paper_adc);
            ret = adc < 790 ? 1 : 0;
        } else {
            try {
                this.sendCmd(PrinterCommand.cmdGSrn(1));
                ret = this.mPrinter.read(status, 1);
                this.sendCmd(PrinterCommand.cmdGSrn(1));
                ret |= this.mPrinter.read(status, 1);
            }
            catch (SmartPosException e2) {
                if (this.mPrinter.getType() == 1) {
                    ret = 1;
                    status[0] = 0;
                }
                ret = 0;
            }
            Log.d((String)TAG, (String)("paper status:" + Integer.toHexString(status[0])));
            status[0] = (byte)(status[0] & 0xF);
        }
        if (ret == 0 || status[0] != 0) {
            throw new SmartPosException(6);
        }
    }

    public void setStringEncoding(String encoding) throws SmartPosException {
        if (encoding == null) {
            throw new SmartPosException(5);
        }
        this.mEncoding = encoding;
    }

    public synchronized void sendData(String data) throws SmartPosException {
        this.sendData(data, this.mEncoding);
    }

    public synchronized void sendData(String data, String encoding) throws SmartPosException {
        if (data == null || encoding == null) {
            throw new SmartPosException(5);
        }
        if (this.mPrinter.getType() == 2 && this.mTotalCount < 1) {
            this.mFirstStamp = SystemClock.uptimeMillis();
        }
        try {
            byte[] cmd = data.getBytes(Charset.forName(encoding));
            if (cmd.length > 1023) {
                int i2 = 0;
                int count = cmd.length >> 10;
                int end = cmd.length - (count << 10);
                byte[] tmp = new byte[1024];
                byte[] last = new byte[end];
                while (count-- > 0) {
                    System.arraycopy(cmd, i2, tmp, 0, 1024);
                    this.mPrinter.write(tmp, tmp.length);
                    i2 += 1024;
                }
                System.arraycopy(cmd, i2, last, 0, end);
                this.mPrinter.write(last, last.length);
            } else {
                this.mPrinter.write(cmd, cmd.length);
            }
            if (this.mPrinter.getType() == 2) {
                this.mTotalCount += data.length();
            }
        }
        catch (IllegalCharsetNameException e2) {
            e2.printStackTrace();
            throw new SmartPosException(5);
        }
    }

    public synchronized void sendCmd(byte[] cmd) throws SmartPosException {
        if (cmd == null) {
            throw new SmartPosException(5);
        }
        if (this.mPrinter.getType() == 2 && this.mTotalCount < 1) {
            this.mFirstStamp = SystemClock.uptimeMillis();
        }
        if (cmd.length > 1023) {
            int i2 = 0;
            int count = cmd.length >> 10;
            int end = cmd.length - (count << 10);
            byte[] tmp = new byte[1024];
            byte[] last = new byte[end];
            while (count-- > 0) {
                System.arraycopy(cmd, i2, tmp, 0, 1024);
                this.mPrinter.write(tmp, tmp.length);
                i2 += 1024;
            }
            System.arraycopy(cmd, i2, last, 0, end);
            this.mPrinter.write(last, last.length);
        } else {
            this.mPrinter.write(cmd, cmd.length);
        }
        if (this.mPrinter.getType() == 2) {
            this.mTotalCount += cmd.length;
        }
    }

    private void sendCmdInternal(byte[] cmd) throws SmartPosException {
        if (cmd.length > 1023) {
            int i2 = 0;
            int count = cmd.length >> 10;
            int end = cmd.length - (count << 10);
            byte[] tmp = new byte[1024];
            byte[] last = new byte[end];
            while (count-- > 0) {
                System.arraycopy(cmd, i2, tmp, 0, 1024);
                this.mPrinter.write(tmp, tmp.length);
                i2 += 1024;
            }
            System.arraycopy(cmd, i2, last, 0, end);
            this.mPrinter.write(last, last.length);
        } else {
            this.mPrinter.write(cmd, cmd.length);
        }
    }

    public void cmdLineFeed() throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdLF());
    }

    public void cmdLineFeed(int n2) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdESCdn(n2));
    }

    public void cmdJumpTab() throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdHT());
    }

    public void cmdUnSetTable() throws SmartPosException {
        byte[] cmd = new byte[]{27, 68, 0};
        this.sendCmd(cmd);
    }

    public void cmdSetTable(byte[] offset) throws SmartPosException {
        if (offset == null) {
            throw new SmartPosException(5);
        }
        if (offset.length > 16) {
            throw new SmartPosException(5);
        }
        this.sendCmd(PrinterCommand.cmdESC_D(offset));
    }

    public void cmdSetDefaultLineSpacing() throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdESC2());
    }

    public void cmdSetLineSpacing(int dots) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdESC3n(dots));
    }

    public void cmdSetAlignMode(int mode) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdESCan(mode));
    }

    public void cmdSetPrintOffset(int offset) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdESC_nLnH(offset & 0xFF, offset >> 8 & 0xFF));
    }

    public void cmdSetPrintMode(int mode) throws SmartPosException {
        if ((mode & 2) == 2) {
            this.sendCmd(PrinterCommand.cmdGSBn(1));
        } else {
            this.sendCmd(PrinterCommand.cmdGSBn(0));
        }
        if ((mode & 4) == 4) {
            this.sendCmd(PrinterCommand.cmdESCbracketN(1));
        } else {
            this.sendCmd(PrinterCommand.cmdESCbracketN(0));
        }
        if ((mode & 0x40) == 64) {
            this.sendCmd(PrinterCommand.cmdESCVN(1));
        } else {
            this.sendCmd(PrinterCommand.cmdESCVN(0));
        }
        this.sendCmd(PrinterCommand.cmdESCexclamationN(mode));
    }

    public void cmdSetUnderlineHeight(int n2) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdESCminusN(n2));
    }

    public void cmdSetFontScaleSize(int scaleWidth, int scaleHeight) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdGSexclamationN((scaleWidth & 0xF) << 4 | scaleHeight & 0xF));
    }

    public void cmdSetBarCodeStringPosition(int mode) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdGSHn(mode));
    }

    public void cmdSetBarCodeStringSize(int size) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdGSfn(size));
    }

    public void cmdSetBarCodeHeight(int n2) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdGShn(n2));
    }

    public void cmdSetBarCodeWidth(int n2) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdGSwn(n2));
    }

    public void cmdSetBarCodeLeftSpacing(int n2) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdGSxn(n2));
    }

    public void cmdBarCodePrint(int type, String string) throws SmartPosException {
        if (string == null) {
            throw new SmartPosException(5);
        }
        byte[] barCode = string.getBytes();
        this.sendCmd(PrinterCommand.cmdGSkmnd(type, barCode.length, barCode));
        ++this.mBmpCount;
    }

    public void cmdBarCodePrint(int type, byte[] stringBytes) throws SmartPosException {
        if (stringBytes == null) {
            throw new SmartPosException(5);
        }
        this.sendCmd(PrinterCommand.cmdGSkmnd(type, stringBytes.length, stringBytes));
        ++this.mBmpCount;
    }

    public void cmdBitmapPrint(Bitmap bitmap, int left, int top) throws SmartPosException {
        byte[] result = null;
        if (bitmap == null) {
            throw new SmartPosException(5);
        }
        if (bitmap.getWidth() + left > this.dots_per_line[this.mPaperWidthType]) {
            Log.d((String)TAG, (String)("bitmap width+left > " + this.dots_per_line[this.mPaperWidthType]));
            throw new SmartPosException(5);
        }
        if (top > 0) {
            this.sendCmdInternal(PrinterCommand.cmdESCjn(top));
        }
        int w = bitmap.getWidth();
        int h2 = bitmap.getHeight();
        int[] pixels = new int[w * h2];
        bitmap.getPixels(pixels, 0, w, 0, 0, w, h2);
        int byteWidth = this.bmp_byte_width[this.mPaperWidthType];
        result = new byte[h2 * byteWidth];
        for (int y = 0; y < h2; ++y) {
            int rowStart = y * w;
            for (int x = 0; x < w; ++x) {
                int color = pixels[rowStart + x];
                if ((color & 0xFF) >= 128 && (color >> 8 & 0xFF) >= 128 && (color >> 16 & 0xFF) >= 128) continue;
                int bitX = x + left;
                int byteX = bitX >> 3;
                int byteY = y;
                int n2 = byteY * byteWidth + byteX;
                result[n2] = (byte)(result[n2] | 128 >> (bitX & 7));
            }
        }
        this.sendCmdInternal(PrinterCommand.cmdGSv0pwLwHhLhHd(0, byteWidth, 0, h2 & 0xFF, h2 >> 8 & 0xFF, result));
        if (this.mPrinter.getType() == 2) {
            this.mPowerOffDelay += (int)((float)(h2 + top) * 2.7f);
        }
    }

    public void cmdBitmapPrintEx(Bitmap bitmap, int left, int top) throws SmartPosException {
        int lines;
        if (bitmap == null) {
            throw new SmartPosException(5);
        }
        if (bitmap.getWidth() + left > this.dots_per_line[this.mPaperWidthType]) {
            Log.d((String)TAG, (String)("bitmap width+left > " + this.dots_per_line[this.mPaperWidthType]));
            throw new SmartPosException(5);
        }
        if (top > 0) {
            this.sendCmdInternal(PrinterCommand.cmdESCjn(top));
        }
        int imgWidth = bitmap.getWidth();
        int blockHeight = 24;
        int w = imgWidth + left;
        int h2 = bitmap.getHeight();
        int blockSize = w * 3;
        this.sendCmdInternal(PrinterCommand.cmdESC3n(0));
        byte[] block = new byte[blockSize];
        int[] pixels = new int[imgWidth * h2];
        bitmap.getPixels(pixels, 0, imgWidth, 0, 0, imgWidth, h2);
        for (lines = 0; lines < h2; lines += 24) {
            Arrays.fill(block, (byte)0);
            int currentBlockHeight = Math.min(24, h2 - lines);
            for (int y = 0; y < currentBlockHeight; ++y) {
                int pixelY = y + lines;
                int rowStart = pixelY * imgWidth;
                for (int x = left; x < w; ++x) {
                    int color = pixels[rowStart + x - left];
                    if ((color >> 16 & 0xFF) >= 128 && (color >> 8 & 0xFF) >= 128 && (color & 0xFF) >= 128) continue;
                    int posBit = x * 24 + y;
                    int n2 = posBit >>> 3;
                    block[n2] = (byte)(block[n2] | 128 >>> (posBit & 7));
                }
            }
            this.sendCmdInternal(PrinterCommand.cmdESCasteriskmhLhHd(33, w & 0xFF, w >> 8 & 0xFF, block));
            this.sendCmdInternal(PrinterCommand.cmdESCjn(0));
        }
        this.sendCmdInternal(PrinterCommand.cmdESC2());
        if (this.mPrinter.getType() == 2) {
            this.mPowerOffDelay += (int)((float)lines * 2.7f);
        }
    }

    public void cmdSetHeatingParam(int dots, int time, int interval) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdESC7n1n2n3(dots, time, interval));
    }

    public void cmdSetPrintDensity(int density, int delay) throws SmartPosException {
        int arg = delay << 5 & 7 | density & 0x1F;
        this.sendCmd(PrinterCommand.cmdDC2_n(arg));
    }

    public void cmdSetCharacterSet(int set) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdESCRn(set));
    }

    public void cmdSetPrinterLanguage(int code) throws SmartPosException {
        switch (code) {
            case 99: {
                this.sendCmd(new byte[]{28, 38});
                this.sendCmd(new byte[]{27, 57, 0});
                break;
            }
            case 98: {
                this.sendCmd(new byte[]{28, 38});
                this.sendCmd(new byte[]{27, 57, 3});
                break;
            }
            case 96: {
                this.sendCmd(new byte[]{28, 38});
                this.sendCmd(new byte[]{27, 57, 4});
                break;
            }
            case 97: {
                this.sendCmd(new byte[]{28, 38});
                this.sendCmd(new byte[]{27, 57, 5});
                break;
            }
            default: {
                this.sendCmd(new byte[]{28, 46});
                this.sendCmd(new byte[]{27, 116, (byte)code});
            }
        }
    }

    public void cmdQrCodePrint(int version, int ecc, String data) throws SmartPosException {
        byte[] cmd1 = new byte[]{29, 40, 107, 3, 0, 49, 67, (byte)version};
        byte[] cmd2 = new byte[]{29, 40, 107, 3, 0, 49, 69, (byte)(ecc + 47)};
        byte[] cmd3 = new byte[]{29, 40, 107, 3, 0, 49, 82, 48};
        byte[] cmd4 = new byte[]{29, 40, 107, 3, 0, 49, 81, 48};
        byte[] str = data.getBytes();
        byte[] cmd = new byte[str.length + 8];
        cmd[0] = 29;
        cmd[1] = 40;
        cmd[2] = 107;
        cmd[3] = (byte)(str.length + 3 & 0xFF);
        cmd[4] = (byte)(str.length + 3 >> 8 & 0xFF);
        cmd[5] = 49;
        cmd[6] = 80;
        cmd[7] = 48;
        System.arraycopy(str, 0, cmd, 8, str.length);
        this.sendCmd(cmd1);
        this.sendCmd(cmd2);
        this.sendCmd(cmd);
        this.sendCmd(cmd3);
        this.sendCmd(cmd4);
        ++this.mBmpCount;
    }

    public void cmdPrintMultipleLines(int lineCount, int[] lineStartPos, int[] lineEndPos) throws SmartPosException {
        if (lineStartPos == null || lineEndPos == null) {
            throw new SmartPosException(5);
        }
        byte[] cmd = new byte[(lineCount << 2) + 3];
        cmd[0] = 29;
        cmd[1] = 39;
        cmd[2] = (byte)lineCount;
        int j2 = 3;
        int i2 = 0;
        while (i2 < lineCount) {
            cmd[j2] = (byte)(lineStartPos[i2] & 0xFF);
            cmd[j2 + 1] = (byte)(lineStartPos[i2] >> 8 & 0xFF);
            cmd[j2 + 2] = (byte)(lineEndPos[i2] & 0xFF);
            cmd[j2 + 3] = (byte)(lineEndPos[i2] >> 8 & 0xFF);
            ++i2;
            j2 += 4;
        }
        this.sendCmdInternal(cmd);
    }

    public void cmdSaveBitmapToNVRAM(Bitmap[] bmpArray) throws SmartPosException {
        int blockLastBytes;
        if (bmpArray == null) {
            throw new SmartPosException(5);
        }
        int bmpCount = bmpArray.length;
        int totalBytes = 3;
        for (int i2 = 0; i2 < bmpCount; ++i2) {
            int w = bmpArray[i2].getWidth();
            int h2 = bmpArray[i2].getHeight();
            totalBytes += (w * h2 >> 3) + 4;
        }
        int blockCount = totalBytes >> 8;
        int n2 = blockLastBytes = blockCount > 1 ? totalBytes - (blockCount << 8) : 0;
        if (totalBytes > 65535) {
            throw new SmartPosException(5);
        }
        byte[] cmdNvMode = new byte[]{3, -1, 47, 0, 1, 0, 0, 0, 0, 0, -46, 0};
        byte[] cmdNvData = new byte[]{3, -1, 45, 0, 0, 0, 26, 0, 0, 1, -54, 89};
        byte[] data = new byte[totalBytes];
        data[0] = -86;
        data[1] = -35;
        data[2] = (byte)bmpCount;
        int offset = 3;
        for (int i3 = 0; i3 < bmpCount; ++i3) {
            int w = bmpArray[i3].getWidth();
            int h3 = bmpArray[i3].getHeight();
            byte[] bmp = new byte[(w * h3 >> 3) + 4];
            bmp[0] = (byte)(w >> 3 & 0xFF);
            bmp[1] = (byte)(w >> 3 >> 8 & 0xFF);
            bmp[2] = (byte)(h3 >> 3 & 0xFF);
            bmp[3] = (byte)(h3 >> 3 >> 8 & 0xFF);
            for (int y = 0; y < h3; ++y) {
                for (int x = 0; x < w; ++x) {
                    int color = bmpArray[i3].getPixel(x, y);
                    int red = Color.red((int)color);
                    int green = Color.green((int)color);
                    int blue = Color.blue((int)color);
                    if (red >= 128 && green >= 128 && blue >= 128) continue;
                    int bitX = y * w + x;
                    int bitPos = bitX % 8;
                    int byteX = bitX >> 3;
                    int n3 = byteX + 4;
                    bmp[n3] = (byte)(bmp[n3] | 128 >> bitPos);
                }
            }
            System.arraycopy(bmp, 0, data, offset, bmp.length);
            offset += bmp.length;
        }
        this.sendCmdInternal(cmdNvMode);
        if (blockLastBytes < 1) {
            byte[] pack = new byte[totalBytes + cmdNvData.length];
            System.arraycopy(cmdNvData, 0, pack, 0, cmdNvData.length);
            System.arraycopy(data, 0, pack, cmdNvData.length, totalBytes);
            pack[5] = 0;
            pack[8] = (byte)(totalBytes & 0xFF);
            pack[9] = (byte)(totalBytes >> 8 & 0xFF);
            pack[10] = (byte)this.calcXorSum(pack, 0, 10);
            pack[11] = (byte)this.calcXorSum(pack, 12, totalBytes);
            this.sendCmdInternal(pack);
        } else {
            byte[] pack = new byte[268];
            for (int i4 = 0; i4 < blockCount; ++i4) {
                System.arraycopy(cmdNvData, 0, pack, 0, cmdNvData.length);
                System.arraycopy(data, i4 << 8, pack, cmdNvData.length, 256);
                pack[5] = (byte)i4;
                pack[8] = 0;
                pack[9] = 1;
                pack[10] = (byte)this.calcXorSum(pack, 0, 10);
                pack[11] = (byte)this.calcXorSum(pack, 12, 256);
                this.sendCmdInternal(pack);
            }
            byte[] lastPack = new byte[blockLastBytes + cmdNvData.length];
            System.arraycopy(cmdNvData, 0, lastPack, 0, cmdNvData.length);
            System.arraycopy(data, blockCount << 8, lastPack, cmdNvData.length, blockLastBytes);
            lastPack[5] = (byte)blockCount;
            lastPack[8] = (byte)(blockLastBytes & 0xFF);
            lastPack[9] = (byte)(blockLastBytes >> 8 & 0xFF);
            lastPack[10] = (byte)this.calcXorSum(lastPack, 0, 10);
            lastPack[11] = (byte)this.calcXorSum(lastPack, 12, blockLastBytes);
            this.sendCmdInternal(lastPack);
        }
    }

    public void cmdDeleteBitmapFromNVRAM() throws SmartPosException {
        this.sendCmd(new byte[]{28, 113, 0});
    }

    public void cmdPrintBitmapFromNVRAM(int index, int zoom) throws SmartPosException {
        if (index < 1 || index > 255 || zoom < 0 || zoom > 3) {
            throw new SmartPosException(5);
        }
        this.sendCmd(new byte[]{28, 112, (byte)index, (byte)zoom});
        ++this.mBmpCount;
    }

    public void cmdPrintTest() throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdDC2T());
        if (this.mPrinter.getType() == 2) {
            this.mPowerOffDelay += 1500;
        }
    }

    public void cmdCutPaper(int mode) throws SmartPosException {
        this.sendCmd(PrinterCommand.cmdGSvm(mode));
    }

    public void fwUpdate(AssetManager am, String name) throws SmartPosException {
        int mPowerIO = SystemProperties.getInt((String)"hw.io.printer", (int)68);
        File file = new File("/dev/printer_io");
        if (file.exists()) {
            this.writeIO(file, "1");
        } else {
            Gpio.init(mPowerIO);
            Gpio.setMode(mPowerIO, 1);
            Gpio.setValue(mPowerIO, 1);
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (DeviceNative.nativePrinterFwUpdate(am, name) < 0) {
            if (file.exists()) {
                this.writeIO(file, "0");
            } else {
                Gpio.setValue(mPowerIO, 0);
                Gpio.deinit(mPowerIO);
            }
            throw new SmartPosException(7);
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (file.exists()) {
            this.writeIO(file, "0");
        } else {
            Gpio.setValue(mPowerIO, 0);
            Gpio.deinit(mPowerIO);
        }
    }

    public int cmdGetPrinterModel() {
        return DeviceNative.nativePrinterGetModel();
    }

    public int getDotsPerLine() {
        return this.dots_per_line[this.mPaperWidthType];
    }

    public boolean isBuiltInSlow() {
        return SystemProperties.getBoolean((String)"hw.printer_slow", (boolean)false);
    }

    private int calcXorSum(byte[] array, int start, int count) {
        int sum = 0;
        for (int i2 = start; i2 < start + count; ++i2) {
            sum ^= array[i2] & 0xFF;
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIO(File file, String data) {
        if (file != null) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                fos.write(data.getBytes());
            }
            catch (NullPointerException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e2) {}
            }
        }
    }

    private void turnOn(boolean on) {
        File file = new File("/dev/printer_io");
        if (file.exists()) {
            this.writeIO(file, on ? "1" : "0");
        } else {
            int powerIO = SystemProperties.getInt((String)"hw.io.printer", (int)68);
            Gpio.init(powerIO);
            Gpio.setMode(powerIO, 1);
            Gpio.setValue(powerIO, on ? 1 : 0);
            Gpio.deinit(powerIO);
        }
        try {
            Thread.sleep(120L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

