/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk.printer;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.paydevice.smartpos.sdk.SmartPosException;
import com.paydevice.smartpos.sdk.printer.Printer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UsbPrinter
implements Printer {
    private static final String TAG = "UsbPrinter";
    private static final String ACTION_USB_PERMISSION = "com.paydevice.smartpos.sdk.printer.USB_PERMISSION";
    private static final int BUILTIN_VID = 19267;
    private static final int BUILTIN_PID = 14384;
    private final Context mContext;
    private UsbDevice mUsbDevice;
    private UsbManager mUsbManager;
    private UsbEndpoint mEpWrite;
    private UsbEndpoint mEpRead;
    private UsbDeviceConnection mUsbConnection;

    public UsbPrinter(Context context) {
        this.mContext = context;
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
    }

    public void selectPrinter(UsbDevice device) {
        this.mUsbDevice = device;
    }

    @Override
    public void selectBuiltInPrinter() {
        HashMap usbList = this.mUsbManager.getDeviceList();
        if (usbList != null) {
            for (UsbDevice device : usbList.values()) {
                UsbInterface usbInterface = device.getInterface(0);
                if (usbInterface == null || usbInterface.getInterfaceClass() != 7 || device.getVendorId() != 19267 || device.getProductId() != 14384) continue;
                this.mUsbDevice = device;
            }
        }
    }

    @Override
    public void open() throws SmartPosException {
        if (this.mUsbDevice == null) {
            Log.e((String)TAG, (String)"UsbDevice is null");
            throw new SmartPosException(1);
        }
        if (!this.mUsbManager.hasPermission(this.mUsbDevice)) {
            Log.e((String)TAG, (String)"no usb permission");
            throw new SmartPosException(1);
        }
        UsbInterface usbIf = this.mUsbDevice.getInterface(0);
        this.mEpWrite = usbIf.getEndpoint(1);
        this.mEpRead = usbIf.getEndpoint(0);
        this.mUsbConnection = this.mUsbManager.openDevice(this.mUsbDevice);
        if (this.mUsbConnection != null) {
            if (!this.mUsbConnection.claimInterface(usbIf, true)) {
                Log.e((String)TAG, (String)"claimInterface fail");
                throw new SmartPosException(1);
            }
        } else {
            Log.e((String)TAG, (String)"open fail");
            throw new SmartPosException(1);
        }
    }

    @Override
    public void close() throws SmartPosException {
        if (this.mUsbConnection == null) {
            throw new SmartPosException(2);
        }
        this.mUsbConnection.close();
        this.mUsbConnection = null;
    }

    @Override
    public int read(byte[] buf, int len) throws SmartPosException {
        return this.read(buf, len, 1000);
    }

    @Override
    public void write(byte[] buf, int len) throws SmartPosException {
        this.write(buf, buf.length, 1000);
    }

    @Override
    public int getType() {
        return 1;
    }

    public int read(byte[] buf, int len, int timeout) throws SmartPosException {
        int ret = 0;
        if (buf != null && this.mUsbConnection != null && this.mEpRead != null) {
            ret = this.mUsbConnection.bulkTransfer(this.mEpRead, buf, len, timeout);
            if (ret < 0) {
                throw new SmartPosException(3);
            }
        } else {
            throw new SmartPosException(3);
        }
        return ret;
    }

    public void write(byte[] buf, int len, int timeout) throws SmartPosException {
        if (this.mUsbConnection != null && this.mEpWrite != null) {
            if (this.mUsbConnection.bulkTransfer(this.mEpWrite, buf, len, timeout) < 0) {
                throw new SmartPosException(4);
            }
        } else {
            throw new SmartPosException(4);
        }
    }

    public List<UsbDevice> getPrinterList() {
        HashMap usbList = this.mUsbManager.getDeviceList();
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        if (usbList != null) {
            for (UsbDevice device : usbList.values()) {
                UsbInterface usbInterface = device.getInterface(0);
                if (usbInterface == null || usbInterface.getInterfaceClass() != 7) continue;
                result.add(device);
            }
        }
        return result;
    }

    static {
        try {
            System.loadLibrary("paydevice-smartpos");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

