package com.paydevice.smartpos.demo;


import android.Manifest;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.ImageFormat;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.media.ImageReader;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;


import java.util.Arrays;

@SuppressLint("ViewConstructor")
public class CameraPreview extends SurfaceView
        implements SurfaceHolder.Callback {

    public static final String TAG = "CameraPreview";

    private final SurfaceHolder mHolder;
    private CameraManager mCameraManager;
	private CaptureRequest.Builder mBuilder;
    private CameraCaptureSession mCameraCaptureSession;
    private CameraDevice mCameraDevice;
    private final String mCameraID;
    private ImageReader mImageReader;
	private final Context mContext;
    private boolean mFlashSupport = true;

    public CameraPreview(Context context, ImageReader.OnImageAvailableListener frameCallback) {
        super(context);
		mContext = context;

        mHolder = getHolder();
        mHolder.addCallback(this);
        mHolder.setKeepScreenOn(true);

        mImageReader = ImageReader.newInstance(640, 480, ImageFormat.YUV_420_888, 2);
		if (frameCallback != null) {
			mImageReader.setOnImageAvailableListener(frameCallback, null);
		}
        mCameraManager = (CameraManager) context.getSystemService(Context.CAMERA_SERVICE);
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP) {
            try {
                mCameraID = mCameraManager.getCameraIdList()[0];
                CameraCharacteristics cc = mCameraManager.getCameraCharacteristics(mCameraID);
                mFlashSupport = cc.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                Log.d(TAG,"cam id:"+mCameraID+" flash support:"+mFlashSupport);
            } catch (CameraAccessException e) {
                throw new RuntimeException(e);
            }
        } else {
            mCameraID = "0";
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        try {
            if (ActivityCompat.checkSelfPermission(mContext, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
                return;
            }
            mCameraManager.openCamera(mCameraID, new CameraDevice.StateCallback() {
                @Override
                public void onOpened(CameraDevice camera) {
                    mCameraDevice = camera;
					if (mCameraDevice != null) {
						startPreview();
					}
                }

                @Override
                public void onDisconnected(CameraDevice camera) {
					camera.close();
					mCameraDevice = null;
                }

                @Override
                public void onError(CameraDevice camera, int error) {
                    Log.e(TAG, "onError:" + error);
					camera.close();
					mCameraDevice = null;
                }
            }, null);
        } catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
		stopPreview();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {

    }

	public boolean cameraExist() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            try {
                return (mCameraManager.getCameraIdList().length == 0)?false:true;
            } catch (CameraAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private void startPreview() {
        try {
            CameraCharacteristics cc = mCameraManager.getCameraCharacteristics(mCameraID);
            int orientation = cc.get(CameraCharacteristics.SENSOR_ORIENTATION);
            Log.d(TAG,"orientation:"+orientation);
            mBuilder = mCameraDevice.createCaptureRequest(CameraDevice.TEMPLATE_PREVIEW);
            mBuilder.addTarget(mHolder.getSurface());
			mBuilder.addTarget(mImageReader.getSurface());
            mCameraDevice.createCaptureSession(Arrays.asList(mHolder.getSurface(), mImageReader.getSurface()),
                    new CameraCaptureSession.StateCallback() {
                        @Override
                        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                            if (mCameraDevice == null)
                                return;
                            mCameraCaptureSession = cameraCaptureSession;
                            try {
                                CaptureRequest request = mBuilder.build();
                                mCameraCaptureSession.setRepeatingRequest(request, null, null);
                            } catch (CameraAccessException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                            Log.e(TAG, "onConfigureFailed");
                        }
                    },
                    null);
        } catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

	private void stopPreview() {
		if (mCameraDevice != null) {
			mCameraDevice.close();
			mCameraDevice = null;
		}
		if (mCameraCaptureSession != null) {
            mCameraCaptureSession.close();
			mCameraCaptureSession = null;
		}
		if (mImageReader != null) {
			mImageReader.close();
			mImageReader = null;
		}
		Log.e(TAG, "stopPreview");
	}

	public void flashOn() {
        if (mCameraDevice != null && mFlashSupport) {
			mBuilder.set(CaptureRequest.FLASH_MODE, CaptureRequest.FLASH_MODE_TORCH);
			try {
				CaptureRequest request = mBuilder.build();
				mCameraCaptureSession.setRepeatingRequest(request, null, null);
			} catch (CameraAccessException e) {
				e.printStackTrace();
			}
		} else {
            Log.d(TAG, "flashlight not support");
        }
	}

	public void flashOff() {
        if (mCameraDevice != null && mFlashSupport) {
			mBuilder.set(CaptureRequest.FLASH_MODE, CaptureRequest.FLASH_MODE_OFF);
			try {
				CaptureRequest request = mBuilder.build();
				mCameraCaptureSession.setRepeatingRequest(request, null, null);
			} catch (CameraAccessException e) {
				e.printStackTrace();
			}
		} else {
            Log.d(TAG, "flashlight not support");
		}
	}
}
