package com.paydevice.smartpos.demo;

import android.support.v7.app.AppCompatActivity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.ViewGroup.LayoutParams;
import android.widget.ImageView;

import com.paydevice.smartpos.sdk.SmartPosException;
import com.paydevice.smartpos.sdk.fingerprint.FingerPrintManager;

import java.io.ByteArrayOutputStream;

public class FingerPrintActivity extends AppCompatActivity {

    private static final String TAG = "FingerPrintActivity";

	private MyToast mToast;
    private ImageView mFingerimage;

    private FingerPrintManager mFingerPrintManager;

    private byte[] imageBytes = null;

    private static final int MSG_FINGER_PRESENT = 1;
    private static final String FP_IMAGE_BYTES = "fp_image_bytes";

    public Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            Boolean result = false;
            switch (msg.what) {
                case MSG_FINGER_PRESENT:
                    result = msg.getData().getBoolean(FP_IMAGE_BYTES);
                    if (result) {
                        mFingerimage.setImageBitmap(Bytes2Bimap(imageBytes));
                    }
                    //deinit
                    if (mFingerPrintManager != null) {
                        mFingerPrintManager.deinit();
                        mFingerPrintManager = null;
                    }
                    break;

                default:
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_fingerprint);
        setTitle(R.string.fingerprint);
        mFingerimage = (ImageView) this.findViewById(R.id.finger_img);
		mToast = new MyToast(this);

		mFingerPrintManager = new FingerPrintManager();
        //set finger image dimension
        LayoutParams lp = mFingerimage.getLayoutParams();
        lp.width = mFingerPrintManager.getBitmapWidth() << 1;
        lp.height = mFingerPrintManager.getBitmapHeight() << 1;
        mFingerimage.setLayoutParams(lp);
        Log.d(TAG, "sensor WxH:" + (lp.width >> 1) + " x " + (lp.height >> 1));
    }

    @Override
    protected void onResume() {
        super.onResume();
        mToast.showToast(R.string.fingerprint_press);
    }

    @Override
    public void onPause() {
        super.onPause();
		mToast.cancel();
        cleanImg();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        //receive finger present event and then read finger image
        if (keyCode == FingerPrintManager.FINGERPRINT_FINGER_PRESENT) {
            Bundle bundle = new Bundle();
            Message msg = new Message();
            msg.what = MSG_FINGER_PRESENT;
            try {
                if (mFingerPrintManager == null) {
					mFingerPrintManager = new FingerPrintManager();
                }
                mFingerPrintManager.init();
                imageBytes = mFingerPrintManager.getBitmapBytes();
                if (imageBytes != null) {
                    Log.d(TAG, "got finger image");
                    bundle.putBoolean(FP_IMAGE_BYTES, true);
                    msg.setData(bundle);
                    mHandler.sendMessage(msg);
                } else {
                    Log.d(TAG, "got finger image null");
                }
            } catch (SmartPosException e) {
                Log.d(TAG, "got finger image err:" + e.getErrorCode());
                mToast.showToast(String.format(getString(R.string.fingerprint_got_img_err), e.getErrorCode()));
                bundle.putBoolean(FP_IMAGE_BYTES, false);
                msg.setData(bundle);
                mHandler.sendMessage(msg);
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private void cleanImg() {
        mFingerimage.setImageDrawable(null);
    }

    /**
     * @param bmp Bitmap
     * @return byte array
     * @brief To convert Bitmap to byte array
     */
    public byte[] Bitmap2Bytes(Bitmap bmp) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bmp.compress(Bitmap.CompressFormat.PNG, 100, baos);
        return baos.toByteArray();
    }

    /**
     * @param raw byte array
     * @return decoded Bitmap or null
     * @brief To convert byte array to Bitmap
     */
    public Bitmap Bytes2Bimap(byte[] raw) {
        if (raw != null && raw.length != 0) {
            return BitmapFactory.decodeByteArray(raw, 0, raw.length);
        } else {
            return null;
        }
    }

}
