package com.paydevice.smartpos.demo;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.media.MediaRouter;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.provider.Settings;
import android.view.Display;
import android.view.WindowManager;
import android.util.Log;

import com.paydevice.smartpos.demo.presentation.VideoPresentation;
import com.paydevice.smartpos.demo.presentation.PhotoPresentation;
import com.paydevice.smartpos.demo.presentation.TextPresentation;
import com.paydevice.smartpos.demo.presentation.CustomerPresentation;
import com.paydevice.smartpos.demo.presentation.CustomerPresentation.CustomerInputListener;

public class SecondaryDisplayService extends Service {

    private static final String TAG = "SecondaryDisplayService";

    public static final int TYPE_VIDEO = 1;
    public static final int TYPE_PHOTO = 2;
    public static final int TYPE_TEXT = 3;
    public static final int TYPE_INPUT = 4;

    CustomerListener mCustomerListener = null;

    private boolean mVideoPlaying = false;
    private boolean mPhotoPlaying = false;
    private boolean mTextPlaying = false;
    private boolean mCustomerPlaying = false;

	private MyToast mToast;
    private MediaRouter mMediaRouter;

    private VideoPresentation mVideoPresentation;
    private PhotoPresentation mPhotoPresentation;
    private TextPresentation mTextPresentation;
    private CustomerPresentation mCustomerPresentation;

    private final MsgBinder mBinder = new MsgBinder();

    public class MsgBinder extends Binder {
        public SecondaryDisplayService getService() {
            return SecondaryDisplayService.this;
        }
    }


    @Override
    public void onCreate() {
        mMediaRouter = (MediaRouter) getSystemService(Context.MEDIA_ROUTER_SERVICE);
        super.onCreate();
		mToast = new MyToast(this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            Log.d(TAG, "Received start id " + startId + ": " + intent.toString());
        }
        return START_REDELIVER_INTENT;
    }

    @Override
    public IBinder onBind(Intent intent) {
        return mBinder;
    }

    @Override
    public void onRebind(Intent intent) {
    }

    @Override
    public boolean onUnbind(Intent intent) {
        return true;
    }


    public void play(int type) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
			if (!Settings.canDrawOverlays(this)) {
				mToast.showToast("no permit drawing over other apps");
				return;
			}
		}
        stop();
        MediaRouter.RouteInfo route = mMediaRouter.getSelectedRoute(MediaRouter.ROUTE_TYPE_LIVE_VIDEO);
        if (route != null) {
            Display secondaryDisplay = route.getPresentationDisplay();
            if (secondaryDisplay != null) {
				//limit extend screen size
				int secondaryScreenWidth = secondaryDisplay.getWidth();
				int secondaryScreenHeight = secondaryDisplay.getHeight();

                switch (type) {
                    case TYPE_VIDEO:
                        Log.d(TAG, "Star play video!");
                        if (mVideoPresentation == null) {
                            mVideoPresentation = new VideoPresentation(getApplicationContext(), secondaryDisplay, R.style.SecondaryDisplay);
							mVideoPresentation.getWindow().setLayout(secondaryScreenWidth,secondaryScreenHeight);
							if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
								mVideoPresentation.getWindow().setType(WindowManager.LayoutParams.TYPE_PHONE);
							}
                        }
                        mVideoPresentation.show();
                        mVideoPlaying = true;
                        break;

                    case TYPE_PHOTO:
                        Log.d(TAG, "Star play photo!");
                        if (mPhotoPresentation == null) {
                            mPhotoPresentation = new PhotoPresentation(getApplicationContext(), secondaryDisplay, R.style.SecondaryDisplay);
							mPhotoPresentation.getWindow().setLayout(secondaryScreenWidth,secondaryScreenHeight);
							if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
								mPhotoPresentation.getWindow().setType(WindowManager.LayoutParams.TYPE_PHONE);
							}
                        }
                        mPhotoPresentation.show();
                        mPhotoPlaying = true;
                        break;

                    case TYPE_TEXT:
                        Log.d(TAG, "Star play text!");
                        if (mTextPresentation == null) {
                            mTextPresentation = new TextPresentation(getApplicationContext(), secondaryDisplay, R.style.SecondaryDisplay);
							mTextPresentation.getWindow().setLayout(secondaryScreenWidth,secondaryScreenHeight);
							if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
								mTextPresentation.getWindow().setType(WindowManager.LayoutParams.TYPE_PHONE);
							}
                        }
                        mTextPresentation.show();
                        mTextPlaying = true;
                        String amount = "100";
                        String change = "10";
                        mTextPresentation.setData(amount, change);
                        break;

                    case TYPE_INPUT:
                        Log.d(TAG, "Star play input!");
                        if (mCustomerPresentation == null) {
                            mCustomerPresentation = new CustomerPresentation(getApplicationContext(), secondaryDisplay, R.style.SecondaryDisplay, new CustomerInputListener() {
                                @Override
                                public void onConfirm(String input) {
                                    String str = getString(R.string.str_get_input) + input;
                                    mToast.showToast(str);
                                    if (mCustomerListener != null) {
                                        mCustomerListener.onConfirm(input);
                                    }
                                }
                            });
							mCustomerPresentation.getWindow().setLayout(secondaryScreenWidth,secondaryScreenHeight);
							if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
								mCustomerPresentation.getWindow().setType(WindowManager.LayoutParams.TYPE_PHONE);
							}
                        }
                        mCustomerPresentation.show();
                        mCustomerPlaying = true;
                        break;
                }
            } else {
                Log.d(TAG, "Have not secondary display!");
                mToast.showToast(R.string.no_secondary_display);
            }
        }
    }

    public void stop() {
        if (mVideoPresentation != null) {
            Log.d(TAG, "Stop play video!");
            mVideoPresentation.dismiss();
            mVideoPlaying = false;
            mVideoPresentation = null;
        }
        if (mPhotoPresentation != null) {
            Log.d(TAG, "Stop play photo!");
            mPhotoPresentation.dismiss();
            mPhotoPlaying = false;
            mPhotoPresentation = null;
        }
        if (mTextPresentation != null) {
            Log.d(TAG, "Stop play text!");
            mTextPresentation.dismiss();
            mTextPlaying = false;
            mTextPresentation = null;
        }
        if (mCustomerPresentation != null) {
            Log.d(TAG, "Stop play input!");
            mCustomerPresentation.dismiss();
            mCustomerPlaying = false;
            mCustomerPresentation = null;
        }
    }

    public boolean isVideoPlaying() {
        return mVideoPlaying;
    }

    public boolean isPhotoPlaying() {
        return mPhotoPlaying;
    }

    public boolean isTextPlaying() {
        return mTextPlaying;
    }

    public boolean isCustomerPlaying() {
        return mCustomerPlaying;
    }

    public void setCustomerListener(CustomerListener l) {
        this.mCustomerListener = l;
    }

    public interface CustomerListener {
        void onConfirm(String input);
    }

}
