/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import com.paydevice.smartpos.sdk.DeviceNative;

public class ImageUtils {
    public static Bitmap bmpToGrayDithering(Bitmap bmp, int threshold, boolean inverse, DitherType type) {
        Bitmap tmp = ImageUtils.bmpToGrayscale(bmp);
        DeviceNative.nativeBitmapToGrayDithering(tmp, threshold, inverse, type.ordinal());
        return tmp;
    }

    public static Bitmap bmpToBlackWhite(Bitmap bmp, int threshold, boolean inverse) {
        Bitmap tmp = ImageUtils.bmpToGrayscale(bmp);
        DeviceNative.nativeBitmapToBlackWhite(tmp, threshold, inverse);
        return tmp;
    }

    private static Bitmap bmpToGrayscale(Bitmap bmp) {
        Bitmap tmp = Bitmap.createBitmap((int)bmp.getWidth(), (int)bmp.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        tmp.setDensity(bmp.getDensity());
        Canvas c2 = new Canvas(tmp);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f2 = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f2);
        c2.drawBitmap(bmp, 0.0f, 0.0f, paint);
        return tmp;
    }

    static {
        try {
            System.loadLibrary("paydevice-smartpos");
        }
        catch (NoClassDefFoundError e2) {
            e2.printStackTrace();
        }
    }

    public static enum DitherType {
        ATKINSON,
        BURKES,
        FLOYD_STEINBERG,
        JARVIS,
        SIERRA,
        STUCKI;

    }
}

