/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk.printer;

import android.util.Log;
import com.paydevice.smartpos.sdk.DeviceNative;
import com.paydevice.smartpos.sdk.SmartPosException;
import com.paydevice.smartpos.sdk.printer.Printer;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.Vector;

public class SerialPortPrinter
implements Printer {
    private static final String TAG = "SerialPortPrinter";
    private static final String BUILTIN_NODE = "/dev/printer";
    private static final int BUILTIN_BAUDRATE = 115200;
    private String mPath;
    private int mSpeed;
    private FileDescriptor mFd;

    public void selectPrinter(String path, int speed) {
        this.mPath = path;
        this.mSpeed = speed;
    }

    @Override
    public void selectBuiltInPrinter() {
        this.mPath = BUILTIN_NODE;
        this.mSpeed = 115200;
    }

    @Override
    public void open() throws SmartPosException {
        if (this.mPath == null) {
            Log.d((String)TAG, (String)"path is null");
            throw new SmartPosException(1);
        }
        try {
            if (this.mPath.equals(BUILTIN_NODE) && DeviceNative.nativePrinterProbe() < 0) {
                Log.e((String)TAG, (String)"probe fail");
                throw new SmartPosException(1);
            }
            this.mFd = DeviceNative.nativeSerialPortOpen(this.mPath, this.mSpeed, 8, 1, 'N', 'S');
        }
        catch (Exception e2) {
            Log.e((String)TAG, (String)"open fail");
            throw new SmartPosException(1);
        }
        if (this.mFd == null) {
            Log.e((String)TAG, (String)"fd is null");
            throw new SmartPosException(1);
        }
    }

    @Override
    public void close() throws SmartPosException {
        if (this.mFd == null) {
            throw new SmartPosException(3);
        }
        DeviceNative.nativeSerialPortClose(this.mFd);
    }

    @Override
    public int read(byte[] buf, int len) throws SmartPosException {
        if (this.mFd == null) {
            throw new SmartPosException(3);
        }
        if (buf == null) {
            throw new SmartPosException(5);
        }
        return DeviceNative.nativeSerialPortRead(this.mFd, buf, len);
    }

    @Override
    public void write(byte[] buf, int len) throws SmartPosException {
        if (this.mFd == null) {
            throw new SmartPosException(4);
        }
        if (buf == null) {
            throw new SmartPosException(5);
        }
        if (DeviceNative.nativeSerialPortWrite(this.mFd, buf, len) != len) {
            throw new SmartPosException(4);
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    public String[] getPrinterList() {
        Vector<String> devices = new Vector<String>();
        try {
            for (Driver driver : this.getDrivers()) {
                Iterator<File> itdev = driver.getDevices().iterator();
                while (itdev.hasNext()) {
                    String device = itdev.next().getAbsolutePath();
                    devices.add(device);
                }
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return devices.toArray(new String[devices.size()]);
    }

    private Vector<Driver> getDrivers() throws IOException {
        String l2;
        Vector<Driver> mDrivers = new Vector<Driver>();
        LineNumberReader r = new LineNumberReader(new FileReader("/proc/tty/drivers"));
        while ((l2 = r.readLine()) != null) {
            String drivername = l2.substring(0, 21).trim();
            String[] w = l2.split(" +");
            if (w.length < 5 || !w[w.length - 1].equals("serial")) continue;
            Log.d((String)TAG, (String)("Found new driver " + drivername + " on " + w[w.length - 4]));
            mDrivers.add(new Driver(drivername, w[w.length - 4]));
        }
        r.close();
        return mDrivers;
    }

    static {
        try {
            System.loadLibrary("paydevice-smartpos");
        }
        catch (NoClassDefFoundError e2) {
            e2.printStackTrace();
        }
    }

    private class Driver {
        private String mDriverName;
        private String mDeviceRoot;
        Vector<File> mDevices = null;

        public Driver(String name, String root) {
            this.mDriverName = name;
            this.mDeviceRoot = root;
        }

        public Vector<File> getDevices() {
            if (this.mDevices == null) {
                this.mDevices = new Vector();
                File dev = new File("/dev");
                File[] files = dev.listFiles();
                for (int i2 = 0; i2 < files.length; ++i2) {
                    if (!files[i2].getAbsolutePath().startsWith(this.mDeviceRoot)) continue;
                    Log.d((String)SerialPortPrinter.TAG, (String)("Found new device: " + files[i2]));
                    if (files[i2].getName().contains("ttyGS") || files[i2].getName().contains("ttyCB") || files[i2].getName().contains("ttyFIQ")) continue;
                    this.mDevices.add(files[i2]);
                }
            }
            return this.mDevices;
        }

        public String getName() {
            return this.mDriverName;
        }
    }
}

