/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk.serialport;

import android.util.Log;
import com.paydevice.smartpos.sdk.DeviceNative;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPort {
    private static final String TAG = "SerialPort";
    private final FileDescriptor mFd;
    private final FileInputStream mFileInputStream;
    private final FileOutputStream mFileOutputStream;

    public SerialPort(File device, int baudrate) throws SecurityException, IOException {
        this(device, baudrate, 8, 1, 'N', 'N');
    }

    public SerialPort(File device, int baudrate, int dataBits, int stopBits, char parity, char flowCtrl) throws SecurityException, IOException {
        this.mFd = DeviceNative.nativeSerialPortOpen(device.getAbsolutePath(), baudrate, dataBits, stopBits, parity, flowCtrl);
        if (this.mFd == null) {
            Log.e((String)TAG, (String)"native open returns null,check params");
            throw new IOException();
        }
        if (!device.canRead() || !device.canWrite()) {
            throw new SecurityException();
        }
        this.mFileInputStream = new FileInputStream(this.mFd);
        this.mFileOutputStream = new FileOutputStream(this.mFd);
    }

    public InputStream getInputStream() {
        return this.mFileInputStream;
    }

    public OutputStream getOutputStream() {
        return this.mFileOutputStream;
    }

    public void close() {
        DeviceNative.nativeSerialPortClose(this.mFd);
    }

    static {
        try {
            System.loadLibrary("paydevice-smartpos");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

