package com.paydevice.websocketserver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;

public class BootReceiver extends BroadcastReceiver {

    private static final String TAG = "SmartPosSocketServer";
	@Override
	public void onReceive(Context context, Intent intent) {
		if (intent != null && context != null) {
			String action = intent.getAction();
			if (action != null) {
				if (action.equals(Intent.ACTION_BOOT_COMPLETED)) {
					Log.d(TAG,"start SmartPosProxyService");
					Intent i = new Intent(context, SmartPosProxyService.class);
					if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
						context.startForegroundService(i);
					} else {
						context.startService(i);
					}
				}
			}
		}
	}
}
